package com.beiming.odr.referee.enums;

import org.springframework.util.ObjectUtils;

/**
 * @author 46915
 * @date 2023/03/17
 * @describes 地区code对应名称
 */
public enum AreaEnum {
  DCJD("441900003000", "东城街道"),
  WJJD("441900005000", "万江街道"),
  NCJD("441900004000", "南城街道"),
  GCJD("441900006000", "莞城街道"),
  SJZ("441900101000", "石碣镇"),
  SLZ("441900102000", "石龙镇"),
  CSZ("441900103000", "茶山镇"),
  SPZ("441900104000", "石排镇"),
  QSZ("441900105000", "企石镇"),
  HLZ("441900106000", "横沥镇"),
  QTZ("441900107000", "桥头镇"),
  XGZ("441900108000", "谢岗镇"),
  DKZ("441900109000", "东坑镇"),
  CPZ("441900110000", "常平镇"),
  LBZ("441900111000", "寮步镇"),
  ZMTZ("441900112000", "樟木头镇"),
  DLZ("441900113000", "大朗镇"),
  HUANGJIANGZ("441900114000", "黄江镇"),
  QXZ("441900115000", "清溪镇"),
  TXZ("441900116000", "塘厦镇"),
  FGZ("441900117000", "凤岗镇"),
  DLSZ("441900118000", "大岭山镇"),
  CAZ("441900119000", "长安镇"),
  HMZ("441900121000", "虎门镇"),
  HOUJIEZ("441900122000", "厚街镇"),
  STZ("441900123000", "沙田镇"),
  DJZ("441900124000", "道滘镇"),
  HONGMEIZ("441900125000", "洪梅镇"),
  MYZ("441900126000", "麻涌镇"),
  WNDZ("441900127000", "望牛墩镇"),
  ZTZ("441900128000", "中堂镇"),
  GBZ("441900129000", "高埗镇"),
  SSHGWH("441900401000", "松山湖管委会"),
  HMGGWH("441900402000", "虎门港管委会"),
  DGSTY("441900403000", "东莞生态园");
  private String code;
  private String name;

  AreaEnum(String code, String name) {
    this.code = code;
    this.name = name;
  }

  /**
   * @param code:
   * @param subStringEndIndex:
   * @Description: 根据code以及比较code的位数返回对应的区域名称
   **/
  public static String getNameByCode(String code, int subStringEndIndex) {
    if (ObjectUtils.isEmpty(code) || code.length() < subStringEndIndex) {
      return "未知";
    }
    AreaEnum[] values = AreaEnum.values();
    for (AreaEnum value : values) {
      if ((value.code.substring(0, subStringEndIndex))
          .equals(code.substring(0, subStringEndIndex))) {
        return value.name;
      }
    }
    return "未知";
  }
}
