package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.responsedto.CaseMaterialResDTO;
import com.beiming.odr.referee.dto.responsedto.CaseMeetingListResDTO;
import com.beiming.odr.referee.dto.responsedto.PageDocumentInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.PageMeetingInfoResDTO;
import com.beiming.odr.referee.dto.responsedto.WorkbenchDocStatusResDTO;
import java.util.ArrayList;
import javax.validation.Valid;

/**
 * 调解附加信息API
 *
 */
@Valid
public interface MediationAdditionalInfoApi {

  DubboResult<ArrayList<CaseMaterialResDTO>> getMediationDocuments(Long lawCaseId);

  DubboResult<ArrayList<CaseMaterialResDTO>> getMediationDocuments(Long lawCaseId, Long currentUseId);

  DubboResult<ArrayList<CaseMeetingListResDTO>> getMediationMeetings(Long lawCaseId, boolean isNew);

  DubboResult<ArrayList<WorkbenchDocStatusResDTO>> getMediationWorkbench(Long lawCaseId, Long userId,
      Boolean workbenchModel);

  DubboResult<PageMeetingInfoResDTO> getUnfinishedMeetings(Long currentUserId, int pageStart, int pageSize);

  DubboResult<PageDocumentInfoResDTO> getUnconfirmedDocuments(Long currentUserId, int pageStart, int pageSize);

  DubboResult countUnfinishedMeeting(Long userId);

  DubboResult countUnconfirmedDocument(Long userId);

}
