package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.arbitration.enums.SuitTypeEnums;
import com.beiming.odr.referee.dto.DelayCancelDTO;
import com.beiming.odr.referee.dto.requestdto.*;
import com.beiming.odr.referee.dto.responsedto.CaseMeetingPersonnelResDTO;
import com.beiming.odr.referee.dto.responsedto.LawCasePersonResDTO;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

/**
 * 调解
 *
 * @author qsh
 * @data 2018年7月3日
 */
@SuppressWarnings("rawtypes")
@Valid
public interface MediationMeetingApi {

  /**
   * 调解成功
   *
   * @return
   */

  DubboResult mediationSuccess(@Valid MediationSuccessFailReqDTO mediationSuccessFailReqDTO);

  DubboResult mediationTurnToSw(MediationTurnReqDTO req);

  /**
   * 调解失败
   *
   * @return
   */
  DubboResult mediationFail(@Valid MediationSuccessFailReqDTO mediationSuccessFailReqDTO);

  /**
   * 重新分配
   *
   * @return
   */
  DubboResult reallocate(@Valid MediationReallocateReqDTO diationReallocateReqDTO);

  /**
   * 受理
   *
   * @return
   */
  DubboResult accept(
      @Valid @NotNull(message = "{case.id.cannot.be.empty}") List<Long> caseIds,
      @Valid @NotNull(message = "{common.parameter.is.null}") Long userId,
      @Valid @NotNull(message = "{common.parameter.is.null}") String userName);

  /**
   * 不受理
   *
   * @return
   */
  DubboResult caseDeclined(@Valid CaseDeclinedReqDTO caseDeclinedReqDTO);

  /**
   * 分配调解员申请
   *
   * @return
   */
  DubboResult reMediatorApplication(
      @Valid ReapportionMediatorApplicationReqDTO requestDTO);

  DubboResult reMediatorApplication2(@Valid ReapportionMediatorApplicationReqDTO requestDTO);

  /**
   * 转移调解机构
   *
   * @param transferMediationReqDTO
   * @return
   */
  DubboResult transferMediation(@Valid TransferMediationReqDTO transferMediationReqDTO);

  /**
   * 查询案件与人员关系
   *
   * @param caseId
   * @param userId
   * @return
   */
  DubboResult<ArrayList<LawCasePersonResDTO>> personList(@Valid @NotNull(
      message = "{common.parameter.is.null}") Long caseId, @Valid @NotNull(
      message = "{common.parameter.is.null}") Long userId);

  /**
   * 申请诉讼，更新案件状态
   *
   * @param caseId 案件id
   * @param updateUserName 更新人名字
   */
  DubboResult goSuit(@Valid @NotNull(
      message = "{case.id.cannot.be.empty}") Long caseId, @Valid @NotNull(
      message = "{common.parameter.is.null}") String updateUserName);

  /**
   * 申请司法确认，更新案件状态
   *  @param caseId 案件id
   * @param updateUserName 更新人名字
   * @param type
   */
  DubboResult goJudicialConfirm(@Valid @NotNull(
      message = "{case.id.cannot.be.empty}") Long caseId, @Valid @NotNull(
      message = "{common.parameter.is.null}") String updateUserName, SuitTypeEnums type);

  /**
   * 小程序会议提醒单条会议
   * 
   * @param userId
   * @return
   */
  DubboResult<CaseMeetingPersonnelResDTO> queryMeetingTime(@Valid @NotNull(
      message = "{user.id.cannot.be.empty}") Long userId, @Valid @NotNull(
      message = "{meeting.status.null}") String meetingStatus, int minute);

  /**
   * 小程序会议提醒多条
   * 
   * @param userId
   * @return
   */
  DubboResult<ArrayList<CaseMeetingPersonnelResDTO>> queryMeetingTimeList(@Valid @NotNull(
      message = "{user.id.cannot.be.empty}") Long userId, @Valid @NotNull(
      message = "{meeting.status.null}") String meetingStatus, int minute);

  /**
   * 查询url路径
   * 
   * @param meetingId
   * @param caseId
   * @return
   */
  DubboResult<ArrayList<CaseMeetingPersonnelResDTO>> queryMeetingPersonnel(@Valid @NotNull(
      message = "{conference.id.cannot.be.empty}") Long meetingId, @Valid @NotNull(
      message = "{user.id.cannot.be.empty}") Long userId, @Valid @NotNull(
      message = "{meeting.status.null}") String meetingStatus);

  DubboResult<ArrayList<LawCasePersonResDTO>> personListAgent(@Valid @NotNull(
      message = "{common.parameter.is.null}") Long caseId, @Valid @NotNull(
      message = "{common.parameter.is.null}") Long userId);

  /**
   * 分配调解机构
   *
   * @param assignOrgReqDTO
   * @return
   */
  DubboResult assignOrg(@Valid AssignOrgReqDTO assignOrgReqDTO);

  /**
   * 调解终止
   *
   * @param mediationSuspendReqDTO
   * @return
   */
  DubboResult mediationSuspend(@Valid MediationSuspendReqDTO mediationSuspendReqDTO);

  /**
   * 延期申请作废
   * @param delayCancelDTO
   * @return
   */
  DubboResult delayCancel(DelayCancelDTO delayCancelDTO);

  /**
   * 转办案件到仲裁
   * @param mediationTurnReqDTO
   * @return
   */
  DubboResult mediationTurnToArbitration(MediationTurnReqDTO mediationTurnReqDTO);

  /**
   * 定时更新仲国商案件信息
   * @param caseId
   * @return
   */
  DubboResult updateArbitrationSyncCase(Long caseId);
}
