package com.beiming.odr.referee.dto;

import com.beiming.odr.referee.constant.LocaleConst;
import java.io.Serializable;
import lombok.Data;
import org.springframework.context.i18n.LocaleContextHolder;

/**
 * @author chenpeng
 * @Title: DictDTO
 * @ProjectName referee
 * @Description: TODO
 * @date 2019/1/3020:52
 */
@Data
public class DictDTO implements Serializable {

  private static final long serialVersionUID = -3282891924580417817L;

  private String code;

  private String name;

  private String twName;

  private String usName;

  private String ghCode;

  public String getName() {
    String locale = LocaleContextHolder.getLocale().toString();
    if (LocaleConst.EN.equalsIgnoreCase(locale)) {
      return usName;
    } else if (LocaleConst.TW.equalsIgnoreCase(locale)) {
      return twName;
    }
    return name;
  }
}
