package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.referee.dto.requestdto.CommonIdReqDTO;
import com.beiming.odr.referee.dto.requestdto.DraftCountReqDTO;
import com.beiming.odr.referee.dto.requestdto.DraftMediationCaseReqDTO;
import com.beiming.odr.referee.dto.requestdto.LawCaseDraftQueryDTO;

public interface LawCaseDraftApi {

  /**
   * 统计数量
   * @param userId
   * @return
   */
  DubboResult<Integer> count(DraftCountReqDTO userId);

  /**
   * 自动保存
   * @param req
   * @return
   */
  DubboResult autoSave(DraftMediationCaseReqDTO req);

  /**
   * 提交
   * @param req
   * @return
   */
  DubboResult submit(DraftMediationCaseReqDTO req);

  /**
   * 分页查询
   * @param req
   * @return
   */
  DubboResult<PageInfo<DraftMediationCaseReqDTO>> page(LawCaseDraftQueryDTO req);

  /**
   * 获取唯一ID
   *
   * @return
   */
  DubboResult<Long> getId(DraftMediationCaseReqDTO req);

  /**
   * 获取详情
   * @param req
   * @return
   */
  DubboResult<DraftMediationCaseReqDTO> detail(CommonIdReqDTO req);

  /**
   * 删除草稿
   * @param req
   * @return
   */
  DubboResult del(CommonIdReqDTO req);
}
