package com.beiming.odr.referee.dto.requestdto;

import com.beiming.odr.referee.annotation.EncryptDecryptData;
import com.beiming.odr.referee.annotation.EncryptDecryptField;
import com.beiming.odr.referee.dto.MediationCaseAgentPersonnelDTO;
import com.beiming.odr.referee.dto.MediationCasePersonnelDTO;
import com.beiming.odr.referee.dto.responsedto.CaseProtocolAgentPersonnelResDTO;
import com.beiming.odr.referee.dto.responsedto.CaseProtocolPersonnelResDTO;
import com.beiming.odr.referee.enums.CaseUserTypeEnum;
import com.beiming.odr.referee.enums.UserSexEnum;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

/**
 * @Description: 案件协议人员请求参数
 * @Author: caiwei
 * @Date: Created 2018-07-01
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EncryptDecryptData
public class CaseProtocolPersonnelReqDTO implements Serializable {

  private static final long serialVersionUID = 7988498493297314452L;

  // 人员id
  private Long personnelId;

  // 案件id
  private Long caseId;

  // 文书id
  private Long documentId;

  // 案件人员类型
  private CaseUserTypeEnum caseUserType;

  // 用户类型
  private String userType;

  // 用户id
  private Long userId;

  // 用户姓名
  private String userName;

  // 手机号
  @EncryptDecryptField
  private String phone;

  // 性别
  private UserSexEnum sex;

  /**
   * 证件类型
   */
  private String cardType;

  // 身份证号
  @EncryptDecryptField
  private String idCard;

  // 省份code
  private String provCode;

  // 城市code
  private String cityCode;

  // 区code
  private String areaCode;

  // 街道code
  private String streetCode;

  // 省份名称
  private String provName;

  // 城市名称
  private String cityName;

  // 区名称
  private String areaName;

  // 街道名称
  private String streetName;

  // 详细地址
  @EncryptDecryptField
  private String address;

  // 信用代码
  @EncryptDecryptField
  private String creditCode;

  // 法人代表
  private String corporation;

  // 排序
  private Integer order;

  /**
   * 电子邮箱
   */
  private String email;

  /** 国籍中文名称 */
  private String nationalityName;
  /** 民族中文名称 */
  private String nationName;
  /** 证件类型中文名称 */
  private String cardTypeName;

  @EncryptDecryptField
  private List<CaseProtocolAgentPersonnelReqDTO> agentList;
  
  private String nationality;

  private String nation;


  /**
   * 不对ID类设值PersonnelId、CaseId、DocumentId
   *
   * @param casePer
   */
  public CaseProtocolPersonnelReqDTO(MediationCasePersonnelDTO casePer) {
    // this.setPersonnelId(null);
    // this.setCaseId(null);
    // this.setDocumentId(null);
    this.setUserId(casePer.getUserId());
    this.setUserType(casePer.getUserType());
    this.setPhone(casePer.getPhone());
    this.setCaseUserType(CaseUserTypeEnum.valueOf(casePer.getCaseUserType()));
    this.setUserName(casePer.getName());
    if (!StringUtils.isBlank(casePer.getSex())) {
      this.setSex(UserSexEnum.valueOf(casePer.getSex()));
    }
    this.setIdCard(casePer.getIdCard());
    this.setProvCode(casePer.getProvCode());
    this.setCityCode(casePer.getCityCode());
    this.setAreaCode(casePer.getAreaCode());
    this.setStreetCode(casePer.getStreetCode());
    this.setProvName(casePer.getProvName());
    this.setCityName(casePer.getCityName());
    this.setAreaName(casePer.getAreaName());
    this.setStreetName(casePer.getStreetName());
    this.setAddress(casePer.getAddress());
    this.setOrder(casePer.getUserOrder());
    this.setEmail(casePer.getEmail());
    List<MediationCaseAgentPersonnelDTO> agents = casePer.getAgentList();
    if (CollectionUtils.isEmpty(agents)) {
      this.agentList = Lists.newArrayList();
    } else {
      this.agentList = agents.stream().map(MediationCaseAgentPersonnelDTO::caseProtocolAgentPersonnelReqDTOConvert).collect(
          Collectors.toList());
    }
  }

  /**
   * 不对ID类设值PersonnelId、CaseId、DocumentId
   *
   * @param casePer
   */
  public CaseProtocolPersonnelReqDTO(CaseProtocolPersonnelResDTO casePer) {
    // this.setPersonnelId(null);
    // this.setCaseId(null);
    // this.setDocumentId(null);
    this.setUserId(casePer.getUserId());
    this.setUserType(casePer.getUserType());
    this.setPhone(casePer.getPhone());
    this.setCaseUserType(CaseUserTypeEnum.valueOf(casePer.getCaseUserType()));
    this.setUserName(casePer.getUserName());
    if (!StringUtils.isBlank(casePer.getSex())) {
      this.setSex(UserSexEnum.valueOf(casePer.getSex()));
    }
    this.setIdCard(casePer.getIdCard());
    this.setProvCode(casePer.getProvCode());
    this.setCityCode(casePer.getCityCode());
    this.setAreaCode(casePer.getAreaCode());
    this.setStreetCode(casePer.getStreetCode());
    this.setProvName(casePer.getProvName());
    this.setCityName(casePer.getCityName());
    this.setAreaName(casePer.getAreaName());
    this.setStreetName(casePer.getStreetName());
    this.setAddress(casePer.getAddress());
    this.setOrder(casePer.getUserOrder());
    this.setEmail(casePer.getEmail());
//    this.setAgentId(casePer.getAgentId());
//    this.setIdCard(casePer.getIdCard());
//    this.setAgentName(casePer.getAgentName());
//    this.setAgentPhone(casePer.getAgentPhone());
//    this.setAgentSex(casePer.getAgentSex());
//    this.setAgentType(casePer.getAgentType());
    List<CaseProtocolAgentPersonnelResDTO> agents = casePer.getAgentList();
    if (CollectionUtils.isEmpty(agents)) {
      this.agentList = Lists.newArrayList();
    } else {
      this.agentList = agents.stream().map(CaseProtocolAgentPersonnelResDTO::caseProtocolAgentPersonnelReqDTOConvert).collect(
          Collectors.toList());
    }
  }

  /**
   * 不对ID类设值PersonnelId、CaseId、DocumentId<br>
   * 不对Order排序设值
   *
   * @param reqDTO
   */
  public CaseProtocolPersonnelReqDTO(MediationDissentSaveReqDTO reqDTO) {
    // this.setPersonnelId(null);
    // this.setCaseId(null);
    // this.setDocumentId(null);
    // this.setOrder(null);
    this.setUserId(reqDTO.getUserId());
    this.setPhone(reqDTO.getPhone());
    this.setUserType(reqDTO.getUserType());
    this.setCaseUserType(CaseUserTypeEnum.valueOf(reqDTO.getCaseUserType()));
    this.setUserName(reqDTO.getUserName());
    if (!StringUtils.isBlank(reqDTO.getSex())) {
      this.setSex(UserSexEnum.valueOf(reqDTO.getSex()));
    }
    this.setIdCard(reqDTO.getIdCard());
    this.setProvCode(reqDTO.getProvCode());
    this.setCityCode(reqDTO.getCityCode());
    this.setAreaCode(reqDTO.getAreaCode());
    this.setStreetCode(reqDTO.getStreetCode());
    this.setProvName(reqDTO.getProvName());
    this.setCityName(reqDTO.getCityName());
    this.setAreaName(reqDTO.getAreaName());
    this.setStreetName(reqDTO.getStreetName());
    this.setAddress(reqDTO.getAddress());

    this.setEmail(reqDTO.getEmail());

    // this.setAgentId(reqDTO.getAgentId());
    // this.setIdCard(reqDTO.getIdCard());
    // this.setAgentName(reqDTO.getAgentName());
    // this.setAgentPhone(reqDTO.getAgentPhone());
    // this.setAgentSex(reqDTO.getAgentSex());
    // this.setAgentType(reqDTO.getAgentType());
  }

}
