package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import lombok.Data;

/**
 * 广东数字接口返回结果
 * 
 * @author qsh
 *
 * @2019年8月1日
 */
@Data
public class GuangDongResultResDTO implements Serializable {


  private static final long serialVersionUID = 1L;

  /**
   * code
   */
  private int errcode;
  /**
   * 错误说明
   */
  private String errmsg;
  /**
   * 列表总数
   */
  private int total;
  /**
   * 数据
   */
  private Object data;

  /**
   * 列表返回
   * 
   * @param errcode
   * @param errmsg
   * @param total
   * @param data
   */
  public GuangDongResultResDTO(int errcode, String errmsg, int total, Object data) {
    super();
    this.errcode = errcode;
    this.errmsg = errmsg;
    this.total = total;
    this.data = data;
  }

  /**
   * 
   * @param errcode
   * @param errmsg
   * @param data
   */
  public GuangDongResultResDTO(int errcode, String errmsg, Object data) {
    super();
    this.errcode = errcode;
    this.errmsg = errmsg;
    this.data = data;
  }

  public GuangDongResultResDTO(int errcode, String errmsg) {
    super();
    this.errcode = errcode;
    this.errmsg = errmsg;
  }

  public GuangDongResultResDTO(int errcode) {
    super();
    this.errcode = errcode;
  }

}
