package com.beiming.odr.referee.dto.requestdto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Data;

@Data
@ApiModel(description = "纠纷批量审批请求参数")
public class MediationDisputeBatchApprovalReqDTO implements Serializable {

  private static final long serialVersionUID = -491109687461536316L;

  @ApiModelProperty(value = "案件ID", position = 0)
  @NotEmpty(message = "{case.id.cannot.be.empty}")
  private List<Long> lawCaseIds;

  @ApiModelProperty(value = "审批意见：true=同意|false=不同意", position = 1)
  @NotNull(message = "{approval.comments.are.not.allowed.to.be.empty}")
  private Boolean isAgree;
}
