package com.beiming.odr.referee.dto.requestdto;

import com.beiming.framework.domain.BaseObject;
import java.io.Serializable;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

/**
 * @Auther: Administrator
 * @Date: 2019/1/9/009 09:30
 * @Description:
 */
@Data
public class MediationExtendReqDTO extends BaseObject implements Serializable {

  private static final long serialVersionUID = 7198320978979150142L;

  @NotNull(message = "案件ID不能为空")
  private Long lawCaseId;

  private String extendStatus;

  /**
   * 延期天数
   */
  private Integer extendDay;

  /**
   * 原因明细
   */
  @Size(max = 500, message = "原因明细长度不能超过500")
  private String extendReason;
  /**
   * 原因类型
   * @see com.beiming.odr.referee.enums.MediationSuccessEnum
   */
  private String reasonType;

  /**
   * 办结类型 SUCCESS_MEDIATION-调解成功，FAIL_MEDIATION-调解失败，RETRACT_CANCEL_CASE-调解撤回
   */
  private String extendAction;

  /**
   * 申请类型 DELAY-延期申请，ASSIGN-重新分配申请，DONE-办结申请
   */
  @Pattern(regexp = "^(DELAY|DONE|ASSIGN)$", message = "申请类型不合法")
  @NotEmpty(message = "申请类型不能为空")
  private String extendType;

  private Long userId;




}
