package com.beiming.odr.referee.dto.responsedto;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Description 案件文书基础数据项
 * @Author blake
 * @Date 2020/3/11 5:34 下午
 * @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DocumentInfoResDTO implements Serializable {

  private static final long serialVersionUID = -3980501328090013532L;

  @ApiModelProperty(value = "案件id", position = 0)
  private Long lawCaseId;

  @ApiModelProperty(value = "文书id", position = 1)
  private String fileId;

  @ApiModelProperty(value = "文书类型", position = 3)
  private String documentType;

  @ApiModelProperty(value = "会议id", position = 4)
  private Long meetingId;

  @ApiModelProperty(value = "案件人员id", position = 5)
  private Long caseUserId;

  @ApiModelProperty(value = "文档主键id", position = 6)
  private Long id;

}
