package com.beiming.odr.referee.enums;

/**
 * @Auther: Administrator
 * @Date: 2019/6/5/005 14:21
 * @Description: 证件类型枚举
 */
public enum CardTypeEnum {
  PRC_IDENTITY_CARD("09_00015-1", "中华人民共和国居民身份证"),

  OFFICER_CERTIFICATE("09_00015-2", "军官证"),
  SOLDIER_CARD("09_00015-3", "士兵证"),
  STUDENT_ID_CARD("09_00015-4", "学生证"),
  POLICE_OFFICER_CERTIFICATE("09_00015-5", "警官证"),
  EMPLOYEE_CARD("09_00015-6", "工作证"),
  PASSPORT("09_00015-7", "护照"),
  LAWYER_LICENSE("09_00015-8", "律师执业证"),
  CREDIT_CODE("09_00015-109", "公司信用代码"),
  OTHER("09_00015-255", "其他");
  private String tdhCode;
  private String name;

  CardTypeEnum(String code, String name) {
    this.tdhCode = code;
    this.name = name;
  }

  public static CardTypeEnum getCardTypeByName(String name) {
    CardTypeEnum result = null;
    for (CardTypeEnum cardTypeEnum : CardTypeEnum.values()) {
      if (cardTypeEnum.getName().equals(name)) {
        result = cardTypeEnum;
      }
    }
    return result;
  }
  public static String getCardTypeByCode(String code) {
    String result = "";
    for (CardTypeEnum cardTypeEnum : CardTypeEnum.values()) {
      if (cardTypeEnum.getTdhCode().equals(code)) {
        result = cardTypeEnum.toString();
      }
    }
    return result;
  }

  public static CardTypeEnum getCardTypeEnumByCode(String code) {
    CardTypeEnum result = null;
    for (CardTypeEnum cardTypeEnum : CardTypeEnum.values()) {
      if (cardTypeEnum.getTdhCode().equals(code)) {
        result = cardTypeEnum;
      }
    }
    return result;
  }

  public String getName() {
    return name;
  }

  public String getTdhCode() {
    return tdhCode;
  }
}
