package com.beiming.odr.referee.enums;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;

/**
 * @Description: 案件状态枚举
 * @Author: caiwei
 * @Date: Created 2018-06-21
 */
public enum CaseStatusEnum {
  TURN_TO_SW("转办到涉外"),
  TURN_TO_ARBITRATION("转办到海南仲国商平台"),
  TURN_TO_ARBITRATION_ACCEPT("海南仲国商平台已受理"),
  TURN_TO_ARBITRATION_REGISTER("海南仲国商平台已立案"),
  TURN_TO_ARBITRATION_CHARGE("海南仲国商平台已财务收费"),
  TURN_TO_ARBITRATION_DEFENSE("海南仲国商平台已答辩"),
  TURN_TO_ARBITRATION_COURT_DATE_SCHEDULING("海南仲国商平台已排期开庭"),
  TURN_TO_ARBITRATION_CLOSE("海南仲国商平台已结案"),
  TURN_TO_ARBITRATION_BRING_TO_JUSTICE("海南仲国商平台已归档"),
  TURN_TO_ARBITRATION_NOACCEPT("海南仲国商平台未立案"),
  BACK_CASE_STATUS("案件状态回退"),
  REFUSE_ACCEPTANCE("不受理"),
  APPLY_SUBMIT("案件申请提交"),
  WAIT_ALLOCATED_TO_MEDIATION_AGENCY("已分配给调解机构"),
  WAIT_TRANSFER_TO_MEDIATION_AGENCY("转移调解机构"),
  WAIT_MEDIATOR_REALLOCATE("纠纷等待分配"),
  //  WAIT_UNABLE_MEDIATION("无法调解"),
  WAIT_CASE_ACCEPTANCE("案件受理"),
  WAIT_SUSPEND_MEDIATION("调解终止"),
  //update的2个改回去
  WAIT_ASSIGNED_TO_MEDIATOR("已分配给调解员"),
  WAIT_MEDIATOR_CHECK_CASE_DATA("调解员查看案件资料"),
  //update的2个改回去
  START_MEDIATION_LOOK_CASE("调解员查看纠纷详情"),
  START_ORDER_MEDIATION_TIME("已预约调解时间"),
  START_ORDER_VIDEO_RESEARCH("已经预约视频调查"),
  START_INVITE_VIDEO_RESEARCH("调解员邀请观摩人"),
  START_MEDIATOR_SEND_RESEARCH_RECORD("调解员发送调查笔录"),
  START_VIDEO_MEDIATION_START("视频调解或调查开始"),
  START_VIDEO_MEDIATION_END("视频调解或调查结束"),

  START_FINANCIAL_REMINDER("催告通知"),
  START_FINANCIAL_COMPRM_STATEMENT("和解声明"),
  START_FINANCIAL_MEDIATION_EFFECT("调解通知"),
  START_FINANCIAL_ACCEPT_NOTICE("受理通知"),

  START_MEDIATION_PROTOCOL_MEDIATOR_SEND("调解员发送调解协议书"),
  START_MEDIATION_PROTOCOL_CONFIRM_FAIL("调解协议确认失败"),
  START_MEDIATION_PROTOCOL_CONFIRM_SUCCESS("调解协议确认成功"),
  START_MEDIATION_PROTOCOL_ONE_REFUSE("一方拒绝了调解协议"),
  START_MEDIATION_PROTOCOL_ONE_CONFIRM("一方确认了调解协议"),

  START_PARTY_SEND_ADDRESS_CONFIRM("发送了地址确认书"),
  START_MEDIATOR_ADDRESS_CONFIRM("确认了地址确认书"),

  START_APPLICATION_MEDIATION_SEND("发送了调解申请书"),
  START_APPLICATION_MEDIATION_CONFIRM("确认了调解申请书"),

  START_CUSTOM_INSTRUMENTS_SEND("调解员发送自定义文书"),
  START_CUSTOM_INSTRUMENTS_ONE_CONFIRM("一方确认了自定义文书"),
  START_CUSTOM_INSTRUMENTS_CONFIRM_SUCCESS("自定义文书确认成功"),
  START_CUSTOM_INSTRUMENTS_ONE_REFUSE("一方拒绝了自定义文书"),
  START_CUSTOM_INSTRUMENTS_CONFIRM_FAIL("自定义文书确认失败"),
  START_CUSTOM_INSTRUMENTS_REFUSE("当事人拒绝了自定义文书"),


  START_UNDISPUTED_FACTS_CONFIRM("确认了无争议事实"),
  START_UNDISPUTED_FACTS_REFUSE("拒绝了无争议事实"),
  START_UNDISPUTED_FACTS_CONFIRM_SUCCESS("无争议事实确认成功"),
  START_UNDISPUTED_FACTS_CONFIRM_FAIL("无争议事实确认失败"),
  START_UNDISPUTED_FACTS_MEDIATOR_SEND("调解员发送了无争议事实"),
  START_NO_OBJECTION_MEDIATION_SCHEME_SEND("发送了无异议调解方案"),

  START_PROMISE_ONE_CONFIRM("一方确认承诺书"),
  START_PROMISE_ONE_REFUSE("一方拒绝承诺书"),
  START_MEDIATION_SCHEME_ONE_CONFIRM("一方同意了调解方案"),
  START_MEDIATION_SCHEME_ONE_REFUSE("一方拒绝了调解方案并且提出了异议书"),
  START_MEDIATION_SCHEME_CONFIRM_SUCCESS("无异议调解方案确认成功"),
  START_MEDIATION_SCHEME_CONFIRM_FAIL("无异议调解方案确认失败"),
  START_ORDER_UNDER_LINE_MEETING_TIME("预约线下会议时间"),
  START_MEDIATION_RECORD_REFUSE("当事人拒绝了调解（调查）笔录"),
  START_MEDIATION_RECORD_AGREE("当事人同意了调解（调查）笔录"),
  RETRACT_CANCEL_CASE("撤回调解案件"),
  FAIL_MEDIATION("调解失败"),
  FAIL_EXCEED_MEDIATION_TERM("超过调解期限"),
  FAIL_SUIT_APPLY("已申请诉讼"),
  SUCCESS_MEDIATION("调解成功"),

  JUDICIAL_CONFIRM_APPLY_SEND("调解员发送了申请司法确认申请书"),
  JUDICIAL_CONFIRM_APPLY_CONFIRM("确认了申请司法确认申请书"),
  JUDICIAL_CONFIRM_REFUSE_APPLY("拒绝了申请司法确认申请书"),
  JUDICIAL_CONFIRM_APPLY_SUCCESS("申请司法确认申请确认成功"),
  JUDICIAL_CONFIRM_APPLY_FAIL("申请司法确认申请确认失败"),
  JUDICIAL_CONFIRM_CHECK("提交预审"),
  JUDICIAL_CONFIRM_ASSIGN("预审分配"),
  JUDICIAL_CONFIRM_CHECK_SUCCESS("预审通过"),
  JUDICIAL_CONFIRM_CHECK_FAIL("预审不通过"),

  JUDICIAL_CONFIRM_APPLY("已申请司法确认"),
  JUDICIAL_CONFIRM_ENTER_HD_SUCCESS("司法确认【广东法院诉讼服务平台】录入成功"),
  JUDICIAL_CONFIRM_ENTER_HD_FAIL("司法确认【广东法院诉讼服务平台】录入失败"),
  SUCCESS_JUDICIAL_CONFIRM("申请司法确认通过"),
  FAIL_JUDICIAL_CONFIRM("申请司法确认不通过"),

  ONLINE_FILING_APPLY("已申请网上立案"),
  ONLINE_FILING_ENTER_HD_SUCCESS("网上立案在【广东法院诉讼服务平台】录入成功"),
  ONLINE_FILING_ENTER_HD_FAIL("网上立案在【广东法院诉讼服务平台】录入失败"),
  SUCCESS_ONLINE_FILING("申请网上立案通过"),
  FAIL_ONLINE_FILING("申请网上立案不通过"),

  SUCCESS_WITHDRAW_APPLY("已申请撤回诉讼"),
  SUCCESS_WITHDRAW_SUCCESS("申请撤回诉讼成功"),
  SUCCESS_WITHDRAW_FAIL("申请撤回诉讼失败"),

  SUCCESS_WITHDRAW_RELATED_TO_GD("调解成功并通过了共道撤诉申请"),
  SUCCESS_WITHDRAW_APPLY_BY_LITIGANT_FROM_GHODR("调解成功且当事人经由广互ODR发起撤诉"),
  SUCCESS_WITHDRAW_APPLY_BY_LITIGANT_FROM_GONGDAO("调解成功且当事人经由共道发起撤诉"),
  SUCCESS_WITHDRAW_APPLY_BY_MEDIATOR("调解成功并由调解员发起撤诉"),

  SUCCESS_MEDIATION_APPLY_SEND("调解员发送了请求法院出具调解书申请"),
  SUCCESS_MEDIATION_APPLY_CONFIRM("确认了请求法院出具调解书申请"),
  SUCCESS_MEDIATION_APPLY_REFUSE("拒绝了请求法院出具调解书申请"),
  SUCCESS_MEDIATION_APPLY_SUCCESS("请求法院出具调解书申请确认成功"),
  SUCCESS_MEDIATION_APPLY_FAIL("请求法院出具调解书申请确认失败"),
  SUCCESS_MEDIATION_APPLY_TO_COURT("已向审判中心发起请求法院出具调解书申请"),
  SUCCESS_MEDIATION_APPLY_TO_COURT_SUCCESS("向审判中心发起请求法院出具调解书申请通过"),
  SUCCESS_MEDIATION_APPLY_TO_COURT_FAIL("向审判中心发起请求法院出具调解书申请不通过"),
  SUCCESS_TDH_MEDIATION_RESULT_FEEDBACK("审批中心调解结果反馈"),

  START_MEDIATION_EXTEND_APPLY("调解员发起了调解期限延长申请"),
  START_MEDIATION_EXTEND_APPLY_AGREE("同意了调解期限延长申请"),
  START_MEDIATION_EXTEND_APPLY_REJECT("作废了调解期限延长申请"),
  START_MEDIATION_EXTEND_APPLY_SUCCESS("调解期限延长申请确认成功"),
  START_MEDIATION_EXTEND_APPLY_FAIL("调解期限延长申请确认失败"),
  START_MEDIATION_EXTEND_APPLY_CANCEL("调解期限延长申请作废"),


  START_MEDIATION_EXTEND_ASSIGN_APPLY("调解员发起了重新分配申请"),
  START_MEDIATION_EXTEND_ASSIGN_APPLY_AGREE("同意了重新分配申请"),
  START_MEDIATION_EXTEND_ASSIGN_APPLY_REJECT("拒绝了重新分配申请"),
  START_MEDIATION_EXTEND_ASSIGN_APPLY_SUCCESS("重新分配申请确认成功"),
  START_MEDIATION_EXTEND_ASSIGN_APPLY_FAIL("重新分配申请确认失败"),


  START_MEDIATION_EXTEND_DONE_APPLY("调解员发起了办结申请"),
  START_MEDIATION_EXTEND_DONE_APPLY_AGREE("同意了办结申请"),
  START_MEDIATION_EXTEND_DONE_APPLY_REJECT("拒绝了办结申请"),
  START_MEDIATION_EXTEND_DONE_APPLY_SUCCESS("调解办结长申请确认成功"),
  START_MEDIATION_EXTEND_DONE_APPLY_FAIL("调解办结申请确认失败"),


  START_SEND_MEDIATION_ACCEPT_FORM("发送了调解受理登记表"),
  START_PARTY_MEDIATION_ACCEPT_FORM("调解受理登记表确认成功"),

  ;

  private String name;

  CaseStatusEnum(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }

  /**
   * 根据状态前缀获取进度枚举值
   *
   * @param caseStatusEnum
   * @return
   */
  public static CaseProgressEnum getCaseProgressEnum(CaseStatusEnum caseStatusEnum) {
    String name = caseStatusEnum.name();
    String caseStatusEnumPre = name.substring(0, name.indexOf("_"));
    if ("ONLINE".equals(caseStatusEnumPre)) {
      caseStatusEnumPre = "FAIL";
    } else if ("JUDICIAL".equals(caseStatusEnumPre)) {
      caseStatusEnumPre = "SUCCESS";
    } else if (caseStatusEnum.equals(CaseStatusEnum.FAIL_JUDICIAL_CONFIRM)) {
      caseStatusEnumPre = "SUCCESS";
    }
    return CaseProgressEnum.valueOf(caseStatusEnumPre);
  }

  /**
   * 根据进度查询状态
   */
  public static List<CaseStatusEnum> queryCaseStatusEnumLst(CaseProgressEnum caseProgressEnum) {
    List<CaseStatusEnum> result = new ArrayList<CaseStatusEnum>();
    EnumSet<CaseStatusEnum> caseStatusEnumSet = EnumSet.allOf(CaseStatusEnum.class);
    for (CaseStatusEnum tmp : caseStatusEnumSet) {
      if (tmp.name().startsWith(caseProgressEnum.name())) {
        result.add(tmp);
      }
    }
    return result;
  }

  /**
   * 对Wait开头的状态进行细分 判断案件是否待分配。
   */
  public static Boolean waitDistribute(String statusCode) {
    List<String> waitStatus = Arrays
        .asList(CaseStatusEnum.WAIT_ALLOCATED_TO_MEDIATION_AGENCY.name(),
            CaseStatusEnum.WAIT_TRANSFER_TO_MEDIATION_AGENCY.name(),
            CaseStatusEnum.WAIT_MEDIATOR_REALLOCATE.name(),
            CaseStatusEnum.WAIT_CASE_ACCEPTANCE.name());
    return waitStatus.contains(statusCode);

  }

  /**
   * 对Wait开头的状态进行细分
   */
  public static Boolean beginCase(String statusCode) {
    List<String> beginStatus = Arrays
        .asList(CaseStatusEnum.WAIT_ASSIGNED_TO_MEDIATOR.name(),
            CaseStatusEnum.WAIT_MEDIATOR_CHECK_CASE_DATA.name(),
            CaseStatusEnum.WAIT_SUSPEND_MEDIATION.name()); //调解开始的状态， 分配了办案秘书，但是办案你是没动
    return beginStatus.contains(statusCode);
  }
}
