package com.beiming.odr.referee.util.sm4util;

import org.apache.commons.codec.binary.Base64;

import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author HUAWEI
 * @date 2022/08/23
 * @Description: 国密SM4对称加密算法，此方法需要配合 SM4_Context,SM4,Utils 共同使用
 */

@SuppressWarnings("restriction")
public class SM4Utils {

  /**
   * 当时用ECB模式的时候，和前端key一致
   */
  private static final String SECRET_KEY = "DJodRR_OdR=zHSHL";

  /**
   * 当时用CBC模式的时候，和前端iv一致
   */
  private static final String IV = "ODR_SiNoSOFT=437";


  private static final String UTF_8 = "UTF-8";

  private static final boolean HEX_STRING = false;

  public static final String DB_ENCRYPT_PREFIX = "xy_db_encrypt_";

  public SM4Utils() {

  }

  /**
   * ECB模式加密
   *
   * @param plainText
   * @return
   */
  public static String encryptDataEcb(String plainText) {
    try {
      SM4Context ctx = new SM4Context();
      ctx.isPadding = true;
      ctx.mode = SM4.SM4_ENCRYPT;

      byte[] keyBytes;
      keyBytes = SECRET_KEY.getBytes();
      SM4 sm4 = new SM4();
      sm4.sm4SetKeyEnc(ctx, keyBytes);
      byte[] encrypted = sm4.sm4CryptEcb(ctx, plainText.getBytes(UTF_8));
      String cipherText = Base64.encodeBase64String(encrypted);
      if (cipherText != null && cipherText.trim().length() > 0) {
        Pattern p = Pattern.compile("\\s*|\t|\r|\n");
        Matcher m = p.matcher(cipherText);
        cipherText = m.replaceAll("");
      }
      return cipherText;
    } catch (Exception e) {
      e.printStackTrace();
      return null;
    }
  }

  /**
   * ECB模式解密
   *
   * @param cipherText
   * @return
   */
  public static String decryptDataEcb(String cipherText) {
    try {
      SM4Context ctx = new SM4Context();
      ctx.isPadding = true;
      ctx.mode = SM4.SM4_DECRYPT;

      byte[] keyBytes;
      keyBytes = SECRET_KEY.getBytes();
      SM4 sm4 = new SM4();
      sm4.sm4SetKeyDec(ctx, keyBytes);
      byte[] decrypted = sm4.sm4CryptEcb(ctx, Base64.decodeBase64(cipherText));
      return new String(decrypted, StandardCharsets.UTF_8);
    } catch (Exception e) {
      e.printStackTrace();
      return null;
    }
  }

  /**
   * CBC模式加密
   *
   * @param plainText
   * @return
   */
  public static String encryptDataCbc(String plainText) {
    try {
      SM4Context ctx = new SM4Context();
      ctx.isPadding = true;
      ctx.mode = SM4.SM4_ENCRYPT;

      byte[] keyBytes;
      byte[] ivBytes;

      keyBytes = SECRET_KEY.getBytes();
      ivBytes = IV.getBytes();

      SM4 sm4 = new SM4();
      sm4.sm4SetKeyEnc(ctx, keyBytes);
      byte[] encrypted = sm4.sm4CryptCbc(ctx, ivBytes, plainText.getBytes(UTF_8));
      String cipherText = Base64.encodeBase64String(encrypted);
      if (cipherText != null && cipherText.trim().length() > 0) {
        Pattern p = Pattern.compile("\\s*|\t|\r|\n");
        Matcher m = p.matcher(cipherText);
        cipherText = m.replaceAll("");
      }
      return cipherText;
    } catch (Exception e) {
      e.printStackTrace();
      return null;
    }
  }

  /**
   * CBC模式解密
   *
   * @param cipherText
   * @return
   */
  public static String decryptDataCbc(String cipherText) {
    try {
      SM4Context ctx = new SM4Context();
      ctx.isPadding = true;
      ctx.mode = SM4.SM4_DECRYPT;

      byte[] keyBytes;
      byte[] ivBytes;
      if (HEX_STRING) {
        keyBytes = Util.hexStringToBytes(SECRET_KEY);
        ivBytes = Util.hexStringToBytes(IV);
      } else {
        keyBytes = SECRET_KEY.getBytes();
        ivBytes = IV.getBytes();
      }

      SM4 sm4 = new SM4();
      sm4.sm4SetKeyDec(ctx, keyBytes);
      byte[] decrypted = sm4.sm4CryptCbc(ctx, ivBytes, Base64.decodeBase64(cipherText));
      return new String(decrypted, StandardCharsets.UTF_8);
    } catch (Exception e) {
      e.printStackTrace();
      return null;
    }
  }

  public static void main(String[] args) {
    System.out.println("xy_db_encrypt_" + encryptDataCbc("15295793474"));
    System.out.println("xy_db_encrypt_" + encryptDataCbc("（2024）多元化解37号"));

    System.out.println(decryptDataCbc("xGaSf5c4sb7JF55F4WxqeQ=="));
    // System.out.println(decryptDataCbc(
    //    "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"));
  }
}
