package com.beiming.odr.referee.api;

import com.beiming.odr.referee.dto.requestdto.VideoPrivateChatReqDTO;
import com.beiming.odr.referee.dto.responsedto.VideoPrivateChatResDTO;
import java.util.ArrayList;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.beiming.framework.domain.DubboResult;

import com.beiming.odr.referee.dto.requestdto.CaseMeetingIdReqDTO;
import com.beiming.odr.referee.dto.requestdto.CaseMeetingInviteReqDTO;
import com.beiming.odr.referee.dto.requestdto.CaseMeetingSaveReqDTO;
import com.beiming.odr.referee.dto.requestdto.LawAttachmentUpFileReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationSuccessFailReqDTO;
import com.beiming.odr.referee.dto.requestdto.UpdateTimeReqDTO;
import com.beiming.odr.referee.dto.responsedto.CaseMeetingListResDTO;
import com.beiming.odr.referee.dto.responsedto.CaseMeetingVideoResDTO;
import com.beiming.odr.referee.dto.responsedto.InviteWatchResDTO;


@Valid
public interface CaseMeetingApi {

  /**
   * 保存会议记录
   *
   * @param caseMeetingSaveReqDTO
   * @return
   */
  @SuppressWarnings("rawtypes")
  DubboResult caseMeetingSave(@Valid CaseMeetingSaveReqDTO caseMeetingSaveReqDTO);

  /**
   * 视频记录
   *
   * @param caseMeetingIdReqDTO
   *
   */
  DubboResult<ArrayList<CaseMeetingVideoResDTO>> getVideo(
      @Valid CaseMeetingIdReqDTO caseMeetingIdReqDTO, String cType);

  /**
   * 邀请观摩人
   *
   * @param caseMeetingInvite
   * @return
   */
  @SuppressWarnings("rawtypes")
  DubboResult sendViewSms(@Valid CaseMeetingInviteReqDTO caseMeetingInvite);

  /**
   * 调解 会议视频 保存上传文件
   *
   * @return
   */
  DubboResult saveUpFile(@Valid LawAttachmentUpFileReqDTO lawAttachmentUpFileReqDTO);

  /**
   * 同过案件id查询调解会议记录
   *
   * @param caseId
   * @return
   */
  DubboResult<ArrayList<CaseMeetingListResDTO>> queryCaseMeetingList(Long caseId);

  /**
   * 会议开始时间更新
   *
   * @param meetingId
   * @return
   */
  DubboResult<Boolean> updateMeetingStartTime(@Valid @NotNull(
      message = "{common.parameter.is.null}") Long meetingId);

  /**
   * 会议结束时间更新
   * @param updateTimeReqDTO
   * @return
   */
  DubboResult updateMeetingEndTime(UpdateTimeReqDTO updateTimeReqDTO);

  /**
   * 通过邀请码生成对应信息
   *
   * @param inviteCode
   * @param userId
   * @param userName
   * @return
   */
  DubboResult<InviteWatchResDTO> inviteWatching(String inviteCode, String userId, String userName);

  /**
   * 调解失败 给调度用
   *
   * @return
   */
  DubboResult mediationFailTask(@Valid MediationSuccessFailReqDTO mediationSuccessFailReqDTO);

  /**
   * 私聊视频
   *
   * @param videoPrivateChatReqDTO
   * @return
   */
  DubboResult<VideoPrivateChatResDTO> meetingVideoPrivateChat(
      @Valid VideoPrivateChatReqDTO videoPrivateChatReqDTO);
}
