package com.beiming.odr.referee.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.io.Serializable;
import java.util.Date;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @ProjectName: hainan-guoshang
 * @Package: com.beiming.odr.referee.dto
 * @ClassName: CaseDispositionRecordDTO
 * @Author: lanqingyun
 * @Description:
 * @Date: 2024/5/10 09:58
 * @Version: 1.0
 */

@Data
@AllArgsConstructor
@NoArgsConstructor
public class CaseDispositionRecordDTO implements Serializable {

  private Long id;
  /**
   * 机构名称
   */
  private String orgName;
  /**
   * 人员名称
   */
  private String peoName;
  /**
   * 处置步骤
   */
  private String dispositionStep;
  /**
   * 处置意见
   */
  private String dispositionOpinion;
  /**
   * 处置时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date dispositionTime;
  /**
   * 案件id
   */
  @NotNull
  private Long caseId;
  /**
   * 文件名称
   */
  private String fileName;
  /**
   * 文件id
   */
  private String fileId;

  private Integer xh;
  /**
   * 状态 0：暂存  1：已提交'
   */
  private Integer type;

  /**
   * 用户ID
   */
  private Long userId;

}
