package com.beiming.odr.referee.dto;

import com.beiming.odr.referee.annotation.EncryptDecryptData;
import com.beiming.odr.referee.annotation.EncryptDecryptField;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import lombok.Data;

/**
 * 案件统计分析入参
 *
 * @author liubao
 * @date 2024/07/23
 */
@Data
@EncryptDecryptData
public class CaseStatisticsReqDTO implements Serializable {

  private static final long serialVersionUID = 4817772379855322213L;
  @EncryptDecryptField
  private String caseName;

  @ApiModelProperty(value = "统计类型 1-机构 2-人员 3-纠纷 4-服务")
  private Integer type;

  @ApiModelProperty(value = "机构名称")
  private String orgName;

  @ApiModelProperty(value = "机构类型")
  private String orgNewTypeCode;

  @ApiModelProperty(value = "开始时间")
  private String startTime;

  @ApiModelProperty(value = "结束时间")
  private String endTime;

  @ApiModelProperty(value = "机构id列表")
  private List<Long> orgIds;

  @ApiModelProperty(value = "机构对应的法院代码")
  private List<String> fydm;

  @ApiModelProperty(value = "调解案件已结状态码")
  private List<String> completeCaseStatus;

  @ApiModelProperty(value = "调解员id")
  private List<Integer> mediatorIds;

  @ApiModelProperty(value = "调解员id对应的承办人标识代码")
  private List<String> cbrdm;

  @ApiModelProperty(value = "解纷类型列表")
  private List<String> disputeTypes;

  @ApiModelProperty(value = "解纷类型对应案由代码")
  private List<String> aydms;
}
