package com.beiming.odr.referee.dto;

import com.beiming.framework.page.PageQuery;
import com.beiming.odr.referee.annotation.EncryptDecryptData;
import com.beiming.odr.referee.annotation.EncryptDecryptField;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 监督案件列表请求参数
 *
 * @author liubao
 * @date 2024/06/27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@EncryptDecryptData
public class SupervisionCaseListDTO extends PageQuery implements Serializable {

  private static final long serialVersionUID = -6730691124012458547L;

  @ApiModelProperty(value = "纠纷编号")
  private String caseNo;

//  @ApiModelProperty(value = "案号")
  @EncryptDecryptField
  private String caseName;

  @ApiModelProperty(value = "案件状态码，诉讼仲裁案件通过状态转换规则获取对应代码用于sql检索")
  private String ajztdm;

  /**
   * 数据状态 0有效 1无效
   */
  private Integer status;

  @ApiModelProperty(value = "调解案件状态检索")
  private String caseProgress;

  @ApiModelProperty(value = "预警限制天数，根据不同案件类型配置计算得出格式为 '30 days'")
  private String warningDays;

  @ApiModelProperty(value = "受理开始时间")
  private String acceptTimeStart;

  @ApiModelProperty(value = "受理结束时间")
  private String acceptTimeEnd;

  @ApiModelProperty(value = "登记开始时间")
  private String registerTimeStart;

  @ApiModelProperty(value = "登记结束时间")
  private String registerTimeEnd;

  @ApiModelProperty(value = "处理期限开始时间")
  private String deadLineTimeStart;

  @ApiModelProperty(value = "处理期限结束时间")
  private String deadLineTimeEnd;

  @ApiModelProperty(value = "案件类型mediate-调解 arbitration-仲裁 litigation-诉讼")
  private String caseType;
}
