package com.beiming.odr.referee.dto.requestdto;

import com.beiming.odr.referee.dto.responsedto.DossAttachmentResDTO;
import com.beiming.odr.referee.enums.CategoryMiddleTypeEnum;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import lombok.Data;

/**
 * @Auther: Administrator
 * @Date: 2019/3/27/027 09:50
 * @Description:
 */
@Data
public class GDEvidenceBodyDTO implements Serializable {

  private String id;
  private String entityName;
  private String name;
  private String content;
  private String submitTime;
  private List<GDFieBodyDTO> files;

  public GDEvidenceBodyDTO(DossAttachmentResDTO resDTO) {
    this.id = resDTO.getId().toString();
    this.entityName = resDTO.getCreateUser();
    this.name = CategoryMiddleTypeEnum.valueOf(resDTO.getCategoryMiddle()).getName();
    this.submitTime = String.valueOf(resDTO.getCreateTime().getTime());
    this.files = Arrays.asList(new GDFieBodyDTO(resDTO));
  }

}
