package com.beiming.odr.referee.dto.requestdto;

import com.beiming.framework.domain.BaseObject;
import com.beiming.odr.referee.annotation.EncryptDecryptData;
import com.beiming.odr.referee.annotation.EncryptDecryptField;
import com.beiming.odr.referee.enums.RegisterOriginEnum;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import lombok.Data;

/**
 * @Auther: Administrator
 * @Date: 2019/3/10/010 17:04
 * @Description:
 */
@Data
@JsonIgnoreProperties
@EncryptDecryptData
public class LawCaseAgentReqDTO extends BaseObject implements Serializable {

  private Long agentId;
  private String partyId; //当事人id
  @EncryptDecryptField
  private String idCard; // 代理人身份证号
  private String defenseType; //辩护类型
  private String citeAgentId; //引调代理人id'
  private String agentName; // 代理人名称
  private Long lawCaseId; //案件id'
  private Long userId; //用户id
  private Long litigantId; //当事人id
  private String litigantName; //当事人名称
  private Long litigantPersonId; //当事人用户表id
  private String litigantCaseUserType; //案件用户类型（申请人 ,被申请人）
  private String sex; //性别'
  private String nation; //民族
  private String nationality; //国籍
  @EncryptDecryptField
  private String lawyerCardNum; //律师证件号
  @EncryptDecryptField
  private String phone; //联系电话
  private String cardType;  //证件类型
  private Integer userOrder; //排序
  private RegisterOriginEnum userRegisterOrigin;  //用户注册来源（默认平台注册）
  private String approvalStatus; //通达海审批状,
  private String agentType; //代理人类型'
  @EncryptDecryptField
  private String telephone; //固定电话'
  private String email; //邮件地址'
  @EncryptDecryptField
  private String address; //地址
}
