package com.beiming.odr.referee.dto.requestdto.calc;

import java.io.Serializable;
import lombok.Data;

/*
 * 侵权类人身损害赔偿计
 */
@Data
public class InfringementDisputeReqDTO implements Serializable {

  private static final long serialVersionUID = -1642101076999031898L;
  // 年龄
  private Integer age;
  // 医疗费
  private Double medicalExpenses;
  // 误工类型
  private Integer lostTimeType;
  // 收入
  private Double lostTimeSalary;
  // 工作天数
  private Double lostTimeDay;
  // 护理类型
  private Integer nurseType;
  // 护理人员收入
  private Double nurseSalary;
  // 护理人员工作天数
  private Double nurseDay;
  // 年份
  private Integer year;
  //  住院天数
  private Double hospitalizationDays;
  //  住宿天数
  private Double stayDays;
  // 营养费
  private Double nutritionExpenses;
  // 残疾赔偿金类型 1-残疾赔偿金, 2-死亡赔偿金
  private Double disabilityType;
  // 伤残系数
  private Integer disabilityCoefficient;

  // 残疾辅助器具费
  private Double feesForDisabilityAids;
  // 交通费
  private Double trafficPay;
  // 丧葬费
//  private Double funeralExpenses;
  // 死亡赔偿金
//  private Double deathCompensation;
  // 有无被抚养人
  private Integer dependentsNum;
  // 抚养义务人数，1-有，大于0
  private Integer caregiverNum;
  // 未成年年龄，多个逗号分隔
  private String juvenilesAge;
  // 无劳动能力，1-有，0-无
  private String inabilityPerson;
  // 被扶养人年龄在1:60周岁--74周岁,多个逗号分隔
  private String dependentAgeOne;
  // 被扶养人年龄在1:75周岁,1-有，多个逗号分隔
  private String dependentAgeTwo;
  // 精神损害赔偿金
  private Double mentalDamages;
  // 外地就医    1-是， 0-否
  private Integer fieldTreatment;


}
