package com.beiming.odr.referee.dto.requestdto.sendtdh;


import com.beiming.odr.referee.enums.CaseStatusEnum;
import com.beiming.odr.referee.enums.CloseCaseEnum;
import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 分配调解机构请求类
 * 
 * @author jache
 * @data 2019年1月8日
 */
@Data
@NoArgsConstructor
public class SycnCaseDubboReqDTO implements Serializable {

  private static final long serialVersionUID = 1L;
  @NotNull(message = "{case.id.cannot.be.empty}")
  private Long caseId;
  @NotNull(message = "{case.status.cannot.be.empty}")
  private CaseStatusEnum caseStatusEnum;
  @NotNull(message = "{diversion.code.can.not.be.empty}")
  private String citeCaseId;
  private Long userId;
  private String userName;
  private CloseCaseEnum closeType; //只针对于诉中

  public SycnCaseDubboReqDTO(Long caseId, CaseStatusEnum caseStatusEnum, String citeCaseId) {
    this.caseId = caseId;
    this.caseStatusEnum = caseStatusEnum;
    this.citeCaseId = citeCaseId;
  }
}
