package com.beiming.odr.referee.dto.responsedto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.metadata.BaseRowModel;
import com.beiming.odr.referee.annotation.EncryptDecryptData;
import com.beiming.odr.referee.annotation.EncryptDecryptField;
import lombok.Data;

import java.io.Serializable;

@Data
@EncryptDecryptData
public class CaseMedTimeFormResDTO extends BaseRowModel implements Serializable {
  @ExcelProperty(value = "机构名称", index = 0)
  private String orgName;

  private Long orgId;

  @ExcelProperty(value = "案件时长0-1天", index = 1)
  private Integer oneToTwo;

  @ExcelProperty(value = "案件时长4-7天", index = 3)
  private Integer fourToSeven;

  @ExcelProperty(value = "案件时长2-3天", index = 2)
  private Integer twoToThree;

  @ExcelProperty(value = "案件时长8-14天", index = 4)
  private Integer eightToFourteen;

  @ExcelProperty(value = "案件时长15-28天", index = 5)
  private Integer fifteenTo28;

  @ExcelProperty(value = "案件时长大于28天", index = 6)
  private Integer bigThan28;

  private Long mediatorId;
  private String mediatorName;

  @EncryptDecryptField
  private String caseNo;

  private String caseProgress;

  private String disputeTime;

  private String medStartTime;

  private String medEndTime;


  private Long caseId;

}
