package com.beiming.odr.referee.dto.responsedto;

import com.beiming.framework.domain.BaseObject;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 文书响应实体类
 * @author xiaoying
 */
@Data
@NoArgsConstructor
@EqualsAndHashCode(callSuper = false)
public class LawDocumentResDTO extends BaseObject implements Serializable {

  private static final long serialVersionUID = -6554646980022204558L;

  /**
   * 文件id
   */
  private String fileId;

  /**
   * 案件id
   */
  private Long lawCaseId;

  /**
   * 文书类型
   */
  private String documentType;

  /**
   * 纠纷类型
   */
  private String disputeType;

  /**
   * 申请人确认
   */
  private String applicantConfirm;

  /**
   * 被申请人确认
   */
  private String respondentConfirm;

  /**
   * 失败/成功确认
   */
  private String confirm;

  /**
   * 文书内容
   */
  private String content;

  /**
   * 组织机构名字
   */
  private String orgName;

  /**
   * 案号
   */
  private String caseNo;

  /**
   * 是否已发送
   */
  private String sendStatus;

  /**
   * 扩展字段
   */
  private String extendJson;

  /**
   * 会议ID
   */
  private Long meetingId;

  private String applicantView;

  private String respondentView;

  private String finalMediationReason;

  private String reasonType;

  /** 调解失败涉及人数。0代表5人以下，5人以上为具体人数 */
  private Integer failurePersonNum;

  /**
   * 文件名称
   */
  private String fileName;

  /**
   * 下载url
   */
  private String downloadUrl;

  /**
   * 文书名称
   */
  private String docName;

  /**
   * 自定义文书模板id
   */
  private Long customDocMldId;
}
