package com.beiming.odr.referee.dto.responsedto;

import com.beiming.odr.referee.dto.MediationCasePersonnelDTO;
import com.beiming.odr.referee.dto.MediationCaseProgressDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 调解列表
 *
 * @author DJQ 2018年6月24日
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MediationListResDTO implements Serializable {

  private static final long serialVersionUID = -2326143176608490189L;

  private Long caseId; // 案件ID
  private String caseNo; // 案件号
  private Date createTime; // 登记时间
  private String lawCaseStatus; // 案件状态
  private Integer approvalType; // 审批类型

  private String origin; // 案件来源
  private Long orgId; // 机构ID
  private Boolean orgConfirm;
  private String orgName; // 调解机构
  private String appeal; // 申请人诉求
  private String orgAreaCode; // 调解机构区域Code

  private String mediationType; // 调解类型
  private String disputeType; // 纠纷类型
  private String disputeTypeCode; // 纠纷类型code
  private String disputeContent; // 纠纷描述

  private Long creatorId; // 案件录入人的ID
  private String creatorType; // 案件录入人的身份
  private Date startTime; // 调解开始时间

  private String provCode; // 发生地代号：省
  private String cityCode; // 发生地代号：市
  private String areaCode; // 发生地代号：区
  private String streetCode; // 发生地代号：街道
  private String communityCode; // 发生地代号：社区

  private String provName; // 发生地名称：省
  private String cityName; // 发生地名称：市
  private String areaName; // 发生地名称：区
  private String streetName; // 发生地名称：街道
  private String communityName; // 发生地名称：社区
  private String address; // 详细地址

  private Boolean allowCancel; // 是否允许撤回 true允许撤回，false不允许撤回（默认为false）

  private List<MediationCaseProgressDTO> progress; // 案件进度

  private List<MediationCaseProgressDTO> suitProgress; // 司法确认和网上立案案件进度

  private List<MediationCasePersonnelDTO> applicants; // 申请人
  private List<MediationCasePersonnelDTO> respondents; // 被申请人
  private List<MediationActualResDTO> mediators; // 调解员

  private List<DossAttachmentResDTO> documents;

  private Long petitionAgentUserId; // 信访代理人Id
  private String petitionAgentUserName; // 信访代理人名字

  /**
   * 调解员id
   */
  private Long mediatorId;

  /**
   * 调解时间延长状态
   */
  private String extendStatus;

  /**
   * 调解时间延长确认状态
   */
  private String confirmStatus;
  /**
   * 调解时间延长天数
   */
  private Integer extendDay;
  /**
   * 延期原因
   */
  private String extendReason;

  private String extendType;

  private String extendAction;

  private String reasonType;

  private Date mediationDeadline;

  /**
   * 延期表id
   */
  private Long extendId;

  private Boolean isSuspend;

  private Integer suspendNum;
  private String citeCaseType;

  /**
   * 案件用户类型（申请人 ,被申请人, 调解员）
   */
  private String caseUserType;

  private String caseTpye;

  private Boolean noEvidenceFlag; //是否无证据
  private Boolean noAllPhoneFlag; //是否号码不齐
  private Boolean financialApprovalFlag; //只针对于金融类案 是否审批
  private String followPersonName;
  private String followPersonPhone;
  private ArrayList<MediationCasePersonnelDTO> mediationHelpDTOs;
  private Integer draft;
  private Integer visit;
  private String disputeAmount; //纠纷金额
  /**
   * 是否转办到涉外 0 ：否，1：是
   */
  private Integer isTurnToSw;

  /**
   * 涉外odr案件ID
   */
  private Long swCaseId;

  private String swCaseNo;

  /**
   * 转办到涉外时间
   */
  private Date turnTime;
  /**
   * 是否简易案件 1是0否
   */
  private Integer simple;

  /**
   * 智能分析是否匹配 0-未匹配 1-匹配
   */
  private Integer matchesResult;

  /**
   * 智能审核结果 0-不通过 1-通过
   */
  private Integer intelligentReviewResult = 0;

  /**
   * 案件类型
   */
  private String resolutionType;

  public MediationListResDTO(Long caseId, String caseNo, Date createTime, String lawCaseStatus,
      Integer approvalType, String origin, Long orgId, Boolean orgConfirm,
      String orgName, String appeal, String mediationType, String disputeType,
      String disputeContent) {
    this.caseId = caseId;
    this.caseNo = caseNo;
    this.createTime = createTime;
    this.lawCaseStatus = lawCaseStatus;
    this.approvalType = approvalType;
    this.origin = origin;
    this.orgId = orgId;
    this.orgConfirm = orgConfirm;
    this.orgName = orgName;
    this.appeal = appeal;
    this.mediationType = mediationType;
    this.disputeType = disputeType;
    this.disputeContent = disputeContent;

  }
}
