package com.beiming.odr.referee.dto.responsedto;

import java.io.Serializable;
import java.util.List;
import lombok.Data;

/**
 * @Description: 调解方案返回实体类
 * @Author: caiwei
 * @Date: Created 2018-07-02
 */
@Data
public class MediationSchemeResDTO implements Serializable {

  private static final long serialVersionUID = -5217593140649624887L;

  // 调解方案id
  private Long id;

  // 案件号
  private String caseNo;

  // 申请方
  private List<CaseProtocolPersonnelResDTO> applicantList;

  // 被申请方
  private List<CaseProtocolPersonnelResDTO> respondentList;

  // 调解方案
  private String mediationScheme = "#pros#与#reps#间的#type#纠纷，双方当事人已书面同意本调解组织适用无异议调解方案认可制度。现就本纠纷提出以下调解方案：";

  // 调解需知
  private String mediationNeeds = "当事人在收到本调解方案后七日内提出书面异议的，视为调解不成立；未提出书面异议的，本调解方案即视为双方自愿达成的调解协议。该调解协议具有合同效力，当事人可以依法申请人民法院进行司法确认。";

  // 是否已发送
  private String sendStatus;

  // 相关人员签名详情
  private List<CaseWholeConfirmResDTO> confirmList;

  public MediationSchemeResDTO() {
    super();
  }

  public MediationSchemeResDTO(ProtocolBookResDTO book) {
    this.id = book.getProtocolId();
    this.caseNo = book.getCaseNo();
    this.applicantList = book.getApplicantList();
    this.respondentList = book.getRespondentList();
    this.sendStatus = book.getSendStatus();
    this.confirmList = book.getConfirmList();
  }
}
