package com.beiming.odr.referee.enums;


/**
 * 案件当事人证件类型对应常量值
 */
public enum HaoDaCardTypeEnum {
  /**
   * 自然人
   */
  PRC_IDENTITY_CARD("09_00015-1", "居民身份证", 1, "0A21"),
  OFFICER_CERTIFICATE("09_00015-2", "军官证", 255, "0A16"),
  SOLDIER_CARD("09_00015-3", "士兵证", 255, "0A16"),
  STUDENT_ID_CARD("09_00015-4", "学生证", 255, "0A16"),
  POLICE_OFFICER_CERTIFICATE("09_00015-5", "警官证", 255, "0A16"),
  EMPLOYEE_CARD("09_00015-6", "工作证", 255, "0A16"),
  PASSPORT("09_00015-7", "护照", 2, "0A03"),
  LAWYER_LICENSE("09_00015-8", "律师执业证", 8, "0A11"),
  /**
   * 法人
   */
  CREDIT_CODE("09_00015-109", "公司信用代码", 4, "0A15"),

  OTHER("09_00015-255", "其他", 255, "0A16");

  private String gycode;
  private String name;
  private int hdcode;
  private String fileType;


  HaoDaCardTypeEnum(String gycode, String name, int hdcode, String fileType) {
    this.gycode = gycode;
    this.name = name;
    this.hdcode = hdcode;
    this.fileType = fileType;
  }

  public static HaoDaCardTypeEnum getCardTypeByCode(String code) {
    HaoDaCardTypeEnum result = null;
    for (HaoDaCardTypeEnum haoDaCardTypeEnum : HaoDaCardTypeEnum.values()) {
      if (haoDaCardTypeEnum.getGycode().equals(code)) {
        result = haoDaCardTypeEnum;
      }
    }
    return result;
  }

  public String getGycode() {
    return gycode;
  }

  public void setGycode(String gycode) {
    this.gycode = gycode;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public int getHdcode() {
    return hdcode;
  }

  public void setHdcode(int hdcode) {
    this.hdcode = hdcode;
  }

  public String getFileType() {
    return fileType;
  }

  public void setFileType(String fileType) {
    this.fileType = fileType;
  }
}
