package com.beiming.odr.referee.util.sm4util;


import com.beiming.odr.referee.annotation.EncryptDecryptData;
import com.beiming.odr.referee.annotation.EncryptDecryptField;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.AnnotationUtils;

/**
 * @author HUAWEI
 * @date 2022/08/23
 */
public class EncryptDecryptUtilCopy {

  /**
   * 数据加密
   *
   * @param declaredFields paramsObject所声明的字段
   * @param paramsObject   mapper中paramsType的实例
   * @return T
   * @throws IllegalAccessException 字段不可访问异常
   */
  public static <T> T encrypt(Field[] declaredFields, T paramsObject) throws IllegalAccessException {
    for (Field field : declaredFields) {
      //取出所有被EncryptDecryptField注解的字段
      EncryptDecryptField sensitiveField = field.getAnnotation(EncryptDecryptField.class);
      if (!Objects.isNull(sensitiveField)) {
        field.setAccessible(true);
        Object object = field.get(paramsObject);
        //暂时只实现String类型的加密
        if (object instanceof String) {
          String value = (String) object;
          //加密
          if (StringUtils.isNotEmpty(value) && !checkIsEncrypt(value)) {
            //xy_db_encrypt_ 加密统一增加前缀字符串 用于避免数据重复加密标识位
            field.set(paramsObject, "xy_db_encrypt_" + SM4Utils.encryptDataCbc(value));
          } else {
            field.set(paramsObject, value);
          }
        }
      }
    }
    return paramsObject;
  }

  /**
   * 数据解密
   *
   * @param result resultType的实例
   * @return T
   * @throws IllegalAccessException 字段不可访问异常
   */
  public static <T> T decrypt(T result) throws IllegalAccessException {
    //取出resultType的类
    Class<?> resultClass = result.getClass();
    Field[] declaredFields = resultClass.getDeclaredFields();
    for (Field field : declaredFields) {
      //取出所有被EncryptDecryptField注解的字段
      EncryptDecryptField sensitiveField = field.getAnnotation(EncryptDecryptField.class);
      if (!Objects.isNull(sensitiveField)) {
        field.setAccessible(true);
        Object object = field.get(result);
        //只支持String的解密
        if (object instanceof String) {
          String value = (String) object;
          if (StringUtils.isNotEmpty(value) && checkIsEncrypt(value)) {
            //去除加密字符串的前缀 xy_db_encrypt_
            field.set(result, SM4Utils.decryptDataCbc(value.substring(14, value.length())));
          } else {
            field.set(result, value);
          }
        } else if (object instanceof List || object instanceof ArrayList) {
          ArrayList resultList = (ArrayList) object;
          if (resultList.size() > 0 && needToDecrypt(resultList.get(0))) {
            for (Object childResult : resultList) {
              //逐一解密
              EncryptDecryptUtilCopy.decrypt(childResult);
            }
          }
        }
      }
    }
    return result;
  }

  private static boolean needToDecrypt(Object object) {
    Class<?> objectClass = object.getClass();
    EncryptDecryptData sensitiveData = AnnotationUtils.findAnnotation(objectClass, EncryptDecryptData.class);
    return Objects.nonNull(sensitiveData);
  }

  /**
   * 判断数据是否已经加密过,避免数据重复加密。
   *
   * @param source 数据
   * @return true 未加密 false 已经加密
   */
  private static Boolean checkIsEncrypt(String source) {
    return source.contains("xy_db_encrypt_");
  }

}