package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.requestdto.MediationRecordGetReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationRecordSaveReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationRecordSendReqDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRecordGetResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRecordSaveResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationRecordSendResDTO;
import javax.validation.Valid;

/**
 * 调解笔录API
 *
 * @author DJQ 2018年6月26日
 *
 */
@Valid
public interface MediationDocRecordApi {

  /**
   * 发送调解笔录
   *
   * @return
   */
  DubboResult<MediationRecordSendResDTO> sendMediationRecord(@Valid MediationRecordSendReqDTO reqDTO);

  /**
   * 获取调解笔录(最新或备份)
   *
   * @return
   */
  DubboResult<MediationRecordGetResDTO> getMediationRecord(@Valid MediationRecordGetReqDTO reqDTO, Boolean isNew);

  /**
   * 保存调解笔录
   *
   * @return
   */
  DubboResult<MediationRecordSaveResDTO> saveMediationRecord(
      @Valid MediationRecordSaveReqDTO reqDTO);

}
