package com.beiming.odr.referee.dto;

import com.beiming.odr.referee.dto.requestdto.MediationCaseAgentReqDTO;
import com.beiming.odr.referee.enums.ApprovalStatusEnum;
import com.beiming.odr.referee.enums.CardTypeEnum;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.StringUtils;

/**
 * @Auther: Administrator
 * @Date: 2019/5/23/023 15:07
 * @Description:
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class CaseAgentTdhDTO implements Serializable {

  @JsonProperty("dlrzt")
  private String mode; //  "1增加、2修改、3删除，必填"
  //下列数据项dlrzt=1时填写
  @JsonProperty("dlrmc")
  @NotNull
  private String agentName;
  @JsonProperty("dldsr")
  @NotNull
  private String litigantName; //代理当事人，必填，如有多个用全角逗号隔开，例：张三,李四
  @JsonProperty("xb")
  private String sex;
  @JsonProperty("mz")
  private String ethnicity; // 民族
  @JsonProperty("csrq")
  private String birthDate;  //出生日期
  @JsonProperty("sfzhm")
  private String idCardNum; //身份证号码
  @JsonProperty("zyzh")
  private String licenseNum; //执业证号
  @JsonProperty("sjhm")
  private String phone; // 手机号码
  @JsonProperty("dz")
  private String address; //地址
  @JsonProperty("szdw")
  private String workAddress; // 工作单位
  //下列数据项dlrzt=2、3时填写
  @JsonProperty("dlrxh")
  private String agentCiteId; //代理人id

  public CaseAgentTdhDTO(MediationCaseAgentReqDTO reqDTO) {
    this.address = reqDTO.getAddress();
    this.mode = ApprovalStatusEnum.NEW.getCode().toString();
    if (CardTypeEnum.PRC_IDENTITY_CARD.getTdhCode().equals(reqDTO.getCardType())) {
      String birthday = StringUtils.substring(reqDTO.getIdCard(), 6, 14);
      this.birthDate = birthday;
    }
    this.ethnicity = reqDTO.getNation();
    this.sex = reqDTO.getSex();
    this.agentName = reqDTO.getAgentName();
    this.idCardNum = reqDTO.getIdCard();
    this.phone = reqDTO.getPhone();
    this.litigantName = reqDTO.getLitigantName();
    this.licenseNum = reqDTO.getLawyerCardNum();
  }

}
