package com.beiming.odr.referee.dto.requestdto;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 案件人员-数据请求DTO
 * @author xiaoying
 * @date 2021/12/10
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class CasePersonnelReqDTO implements Serializable {

  private static final long serialVersionUID = -7719004967037558229L;

  @ApiModelProperty(notes = "主键Id", example = "666")
  private String caseId;

  @ApiModelProperty(notes = "用户主键", example = "666")
  private String userId;

  @ApiModelProperty(notes = "文书主键", example = "666")
  private String documentId;

  @ApiModelProperty(notes = "案件用户类型（申请人 ,被申请人, 调解员）", example = "666")
  private String caseUserType;

  @ApiModelProperty(notes = "用户类型（自然人,法人,非法人组织）", example = "666")
  private String userType;

  @ApiModelProperty(notes = "申请类型", example = "1")
  private String applyType;
}