package com.beiming.odr.referee.dto.requestdto;

import com.beiming.odr.referee.enums.RegisterOriginEnum;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Description
 * @Author blake
 * @Date 2019-07-29 09:45
 * @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@JsonIgnoreProperties
public class LawCasePersonnelReqDTO implements Serializable {

  /**
   * 案件号
   */
  private String caseNum;

  /**
   * 案件id
   */
  private Long lawCaseId;

  /**
   * 案件文书id
   */
  private Long documentId;

  /**
   * 文书类型
   */
  private String documentType;

  /**
   * 用户id
   */
  private Long userId;

  /**
   * 案件用户类型（申请人 被申请人 调解员）
   */
  private String caseUserType;

  /**
   * 用户类型（0：自然人 1：法人 2：非法人组织）
   */
  private String userType;

  /**
   * 名称(类别为法人/非法人组织时, 填单位名称)
   */
  private String userName;

  /**
   * 性别
   */
  private String sex;

  /**
   * 联系电话
   */
  private String phone;

  /**
   * 身份证号
   */
  private String idCard;

  private String cardType;
  /**
   * 省份code
   */
  private String provCode;

  /**
   * 城市code
   */
  private String cityCode;

  /**
   * 区code
   */
  private String areaCode;

  /**
   * 街道code
   */
  private String streetCode;

  /**
   * 省份名称
   */
  private String provName;

  /**
   * 城市名称
   */
  private String cityName;

  /**
   * 区名称
   */
  private String areaName;

  /**
   * 街道名称
   */
  private String streetName;

  /**
   * 详细地址
   */
  private String address;

  /**
   * 信用代码
   */
  private String creditCode;

  /**
   * 法人代表
   */
  private String corporation;
  /**
   * 审批状态
   */
  private String approvalStatus;

  /**
   * 代理人审批状态
   */
  private String approvalAgentStatus;

  /**
   * 排序
   */
  private Integer userOrder;

  /**
   * 用户注册来源(0: 用户自己注册  1: 平台自动注册)
   */
  private RegisterOriginEnum userRegisterOrigin;

  /**
   * 固定电话
   */
  private String telephone;

  /**
   * 电子邮箱
   */
  private String email;

  /**
   * 引调当事人id
   */
  private String citePartyId;

  private Long id;

  //国籍
  private String nationality;
  //民族
  private String nation;

}
