package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotNull;
import lombok.Data;

/**
 * 发送调解笔录的请求对象
 * 
 * @author DJQ 2018年6月26日
 *
 */
@Data
public class MediationRecordSendReqDTO implements Serializable {

  private static final long serialVersionUID = 4014915557247117808L;

  private Long documentId; // ID
  @NotNull(message = "{conference.id.cannot.be.empty}")
  private Long meetingId;
  private Long lawCaseId;
  private String caseNo; // 案件号
  private String disputeType; // 纠纷类型
  private String content; // 笔录内容
  private String location; // 地点
  private String startTime; // 开始时间
  private String endTime; // 开始时间
  @NotNull(message = "{parameter.record.remark.null}")
  private String remark; // 备注
  private List<MediationPersonalReqDTO> mediationParticipants; // 会议参与人信息（调解员）
  private Long currentUserId; //当前token代表的用户id


  public MediationRecordSaveReqDTO convertMediationRecordSaveReqDTO() {
    MediationRecordSaveReqDTO res = new MediationRecordSaveReqDTO();
    res.setDocumentId(this.documentId); // ID
    res.setMeetingId(this.meetingId);
    res.setLawCaseId(this.lawCaseId);
    res.setCaseNo(this.caseNo); // 案件号
    res.setDisputeType(this.disputeType); // 纠纷类型
    res.setContent(this.content); // 笔录内容
    res.setLocation(this.location); // 地点
    res.setStartTime(this.startTime); // 开始时间
    res.setEndTime(this.endTime); // 开始时间
    res.setRemark(this.remark); // 备注
    res.setMediationParticipants(this.mediationParticipants); // 会议参与人信息（调解员）
    res.setCurrentUserId(this.currentUserId);
    return res;
  }

}
