package com.beiming.odr.referee.dto.requestdto;

import com.beiming.odr.referee.enums.DocumentTypeEnum;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * Created by zli on 2019/1/30.
 *
 * 操作者
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ProtocolBookReqDTO implements Serializable {

  private static final long serialVersionUID = -4056657800838724680L;

  @NotNull(message = "{case.id.cannot.be.empty}")
  private Long caseId;

  @NotNull(message = "{document.type.cannot.be.empty}")
  private DocumentTypeEnum documentType;

  /**
   * 文书id，自定义文书需传
   */
  private Long documentId;

  /**
   * 自定义文书模板id
   */
  private Long customDocMldId;
}
