package com.beiming.odr.referee.dto.requestdto.haoda;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 申请-当事人-代理人 备注：（一个当事人最多支持两个代理人）
 *
 * @author xiaoying
 * @date 2021/12/10
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ApplyPartyAgent implements Serializable {

  private static final long serialVersionUID = -7719004967037558229L;

  /**
   * 1 执业律师 2 基层法律服务工作者 3 当事人的近亲属或工作人员 4 当事人所在社区、单位以及有关社会团体推荐的公民 5 经赔偿委员会许可的其他公民 6 法定代理人 255 其他人员
   */
  @ApiModelProperty(notes = "代理人类型", example = "666")
  private Integer type;

  /**
   * 代理人类型 平台专用
   */
  private String agentType;

  @ApiModelProperty(notes = "代理人姓名", example = "666")
  private String name;

  @ApiModelProperty(notes = "代理人证件类型", example = "666")
  private Integer idCardType;

  /**
   * 代理人证件类型 平台自身使用
   */
  private String cardType;

  @ApiModelProperty(notes = "代理人证件号码", example = "666")
  private String idCard;

  @ApiModelProperty(notes = "代理人手机号码", example = "666")
  private String phone;

  @ApiModelProperty(notes = "代理人律师执业证", example = "666")
  private String certificate;

  /**
   * 代理人性别
   */
  private String sex;

  /**
   * 国籍
   */
  private String nationality;

  /**
   * law_case_agent_personnel数据表主键
   */
  private Long id;

}