package com.beiming.odr.referee.dto.requestdto.haoda;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author xiaoying
 * @date 2021/12/24
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class JudicialConfirmHistoryDTO implements Serializable {

  private static final long serialVersionUID = -7601615300834399046L;

  /**
   * 主键
   */
  private Long id;

  /**
   * 创建时间
   */
  private Date createTime;

  /**
   * 司法确认申请用户Id
   */
  private Long createUserId;

  /**
   * 数据状态 0 有效 1为无效
   */
  private Integer status;

  /**
   * 录入结果描述
   */
  private String enteringRemark;

  /**
   * 案件Id
   */
  private Long caseId;

  /**
   * 提交时间
   */
  private Date requestTime;

  /**
   * 昊达-录入时间
   */
  private Date hdResponseTime;

  /**
   * 1 等待录入 2录入成功 3录入失败
   */
  private Integer enteringResult;

  /**
   * 司法确认文书id
   */
  private Long documentId;

  /**
   * 申请类型 1 司法确认 2网上立案
   */
  private Integer type;

  /**
   * 查询案号
   */
  private String queryNo;

  /**
   * 网上立案的诉讼金额
   */
  private String suitMoney;

  /**
   * 司法确认的文书url地址
   */
  private String writUrl;

  /**
   * 司法确认的文书名称
   */
  private String writName;

  /**
   * 昊达审核时间
   */
  private Date hdCheckTime;

  /**
   * 审核结果
   */
  private Integer checkResult;

  /**
   * 审核结果描述
   */
  private String checkRemark;

  /**
   * 版本号
   */
  private Integer version;

}