package com.beiming.odr.referee.enums;

/**
 * @Description: 附件中分类枚举类
 * @Author: caiwei
 * @Date: Created 2018-06-21
 */
public enum CategoryMiddleTypeEnum {

  IDENTITY_CERTIFICATE("身份证明"), EVIDENCE_INVENTORY("证据清单"), DOCUMENT_MATERIAL("文书材料"), OTHER(
      "其他"), LITIGATION_BOOK("申请书（民事特别程序）"), JUDICIAL_EVIDENCE_MATERIAL(
      "司法确认主要证据材料"), JURISDICTION_EVIDENCE_MATERIAL("管辖依据材料"), MATERIALS_LIST(
      "材料清单"), CONFIRMATION_OF_ADDRESS("送达地址确认书"), ENTRUST_LIST("授权委托材料"), ARBITRATION_APPLICATION("仲裁申请书"), ARBITRATION_AGREEMENT("仲裁协议书");
  private String name;

  CategoryMiddleTypeEnum(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }


  public static CategoryMiddleTypeEnum getTypeByValue(String value) {
    for (CategoryMiddleTypeEnum constant : CategoryMiddleTypeEnum.values()) {
      if (constant.toString().equals(value)) {
        return constant;
      }
    }
    return null;
  }

}
