package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.referee.dto.requestdto.CommonIdReqDTO;
import com.beiming.odr.referee.dto.requestdto.LawCaseSubsidyAuditReq;
import com.beiming.odr.referee.dto.requestdto.LawCaseSubsidyQueryDTO;
import com.beiming.odr.referee.dto.requestdto.LawCaseSubsidyReqDTO;
import com.beiming.odr.referee.dto.requestdto.LawCaseSubsidyStatReqDTO;
import com.beiming.odr.referee.dto.responsedto.LawCaseSubsidyResDTO;

public interface LawCaseSubsidyApi {

  /**
   * 申请已案定补
   *
   * @param req
   * @return
   */
  DubboResult apply(LawCaseSubsidyReqDTO req);

  /**
   * 根据ID 查询已案定补详情
   *
   * @param req
   * @return
   */
  DubboResult<LawCaseSubsidyResDTO> get(CommonIdReqDTO req);


  /**
   * 分页查询已案定补列表
   *
   * @param req
   * @return
   */
  DubboResult<PageInfo<LawCaseSubsidyResDTO>> page(LawCaseSubsidyQueryDTO req);


  /**
   * 审核
   *
   * @param req
   * @return
   */
  DubboResult audit(LawCaseSubsidyAuditReq req);


  /**
   * 确认到账
   *
   * @param req
   * @return
   */
  DubboResult confirm(LawCaseSubsidyAuditReq req);

  /**
   * 已案定补统计
   *
   * @param req
   * @return
   */
  DubboResult stat(LawCaseSubsidyStatReqDTO req);

  /**
   * 一已案定补统计一段时间内的总额
   *
   * @param req
   * @return
   */
  DubboResult<Double> statTotal(LawCaseSubsidyStatReqDTO req);
}
