package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.MediateCaseInfoDTO;
import com.beiming.odr.referee.dto.MediateCaseQuery;
import com.beiming.odr.referee.dto.requestdto.OrgCaseStatisticsReqDTO;
import com.beiming.odr.referee.dto.responsedto.StatisticsOrgAreaResDTO;
import java.util.ArrayList;
import java.util.List;

/**
 * 创建于2021-05-20， 新版的统计修改。
 */
public interface ResourceStatementStatisticsApi {

  /**
   * 统计机构案件，总数，受理数，成功数，失败数，撤回数
   */
  DubboResult<ArrayList<StatisticsOrgAreaResDTO>> queryOrgCaseCount(OrgCaseStatisticsReqDTO reqDTO);

  /**
   * 统计调解员的排行榜
   */
  DubboResult<ArrayList<MediateCaseInfoDTO>> queryTopByMediator(MediateCaseQuery caseQuery);

  /**
   * 统计机构的排行榜单
   */
  DubboResult<ArrayList<MediateCaseInfoDTO>> queryTopByOrg(MediateCaseQuery caseQuery);

  /**
   * 统计调解员的调解案件数量
   */
  DubboResult<ArrayList<MediateCaseInfoDTO>> queryMediatorCaseNum(List<Long> userIds);

}
