package com.beiming.odr.referee.dto;

import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Auther: Administrator
 * @Date: 2019/5/23/023 15:07
 * @Description:
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class CaseAgentTdhInfoDTO implements Serializable {

  private String dlrzt; //  "1增加、2修改、3删除，必填"
  private String dlrmc;
  private String dldsr; //代理当事人，必填，如有多个用全角逗号隔开，例：张三,李四
  private String xb;
  private String mz; // 民族
  private String csrq;  //出生日期
  private String sfzhm; //身份证号码
  private String zyzh; //执业证号
  private String sjhm; // 手机号码
  private String dz; //地址
  private String szdw; // 工作单位
  //下列数据项dlrzt=2、3时填写
  private String dlrxh; //代理人id


  public static void setData(CaseAgentTdhInfoDTO caseAgentTdhInfo,
      CaseAgentTdhDTO caseAgentTdhDTO) {
    caseAgentTdhInfo.setDlrzt(caseAgentTdhDTO.getMode());
    caseAgentTdhInfo.setDlrmc(caseAgentTdhDTO.getAgentName());
    caseAgentTdhInfo.setDldsr(caseAgentTdhDTO.getLitigantName());
    caseAgentTdhInfo.setXb(caseAgentTdhDTO.getSex());
    caseAgentTdhInfo.setMz(caseAgentTdhDTO.getEthnicity());
    caseAgentTdhInfo.setCsrq(caseAgentTdhDTO.getBirthDate());
    caseAgentTdhInfo.setSfzhm(caseAgentTdhDTO.getIdCardNum());
    caseAgentTdhInfo.setZyzh(caseAgentTdhDTO.getLicenseNum());
    caseAgentTdhInfo.setSjhm(caseAgentTdhDTO.getPhone());
    caseAgentTdhInfo.setDz(caseAgentTdhDTO.getAddress());
    caseAgentTdhInfo.setSzdw(caseAgentTdhDTO.getWorkAddress());
    caseAgentTdhInfo.setDlrxh(caseAgentTdhDTO.getAgentCiteId());
  }
}
