package com.beiming.odr.referee.dto.requestdto;

import com.beiming.odr.referee.constant.RefereeValidateMessage;
import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Created by zli on 2019/1/30.
 *
 * 操作者
 */
@Data
@NoArgsConstructor
public class OperatorReqDTO implements Serializable {

  private static final long serialVersionUID = -4056657800838724680L;
  /**
   * 操作者ID
   */
  @NotNull(message = RefereeValidateMessage.PARAMETER_USER_ID_NULL)
  private Long operatorId;

  /**
   * 操作者名
   */
  private String operatorName;

  public OperatorReqDTO(Long operatorId, String operatorName) {
    this.operatorId = operatorId;
    this.operatorName = operatorName;
  }
}
