package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;


/**
 * @Description 审批案件人|代理人请求参数
 * @Author blake
 * @Date 2019-07-25 11:32
 * @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class RegionalApprovalReqDTO implements Serializable {

  @NotNull(message = "{case.id.cannot.be.empty}")
  private Long lawCaseId;

//  @NotBlank(message = "身份证号码不允许为空")
  private String idCard;

  @NotNull(message = "{approval.form.id.is.not.allowed.to.be.empty}")
  private Long auditId;

  // @NotNull(message = "主键ID不允许为空")
  private Long id;

  @NotNull(message = "{approval.comments.are.not.allowed.to.be.empty}")
  private Boolean isAgree;

  @NotBlank(message = "{modification.type.is.not.allowed.to.be.empty}")
  private String modifyType;

}
