package com.beiming.odr.referee.dto.responsedto;

import java.io.Serializable;
import lombok.Data;

/**
 * @Description: 案件附件返回
 * @Author: caiwei
 * @Date: Created 2018-06-28
 */
@Data
public class CaseMaterialResDTO implements Serializable {

  private static final long serialVersionUID = 8828835570650670169L;

  // id主键
  private Long id;

  // 附件大分类
  private String categoryBig;

  // 附件中分类
  private String categoryMiddle;

  // 文件类型
  private String sign;
  /**
   * 文件类型中文名称
   */
  private String signName;

  // 文件id
  private String fileId;

  // 文件名称
  private String fileName;

  private byte[] fileByte;

  // 上传者
  private String userName;

  // 上传者id
  private Long userId;

  private String previewUrl;

  private String downloadUrl;

  private String permitUserIds; // 允许访问当前文件的用户ID数组(JSON格式)

  private Boolean accessible; // 当前文件对当前在线用户是否可见
  private String accessibleUsers; // 当前文件有可见权限的用户名称组合
  private String validity; //合法性
  private String validityOpinion; //合法性意见
  private String authenticity;  //真实性
  private String authenticityOpinion; //真实性意见
  private String relevance;   //关联性
  private String relevanceOpinion;  //关联性意见
  private String allowOppugnUserType; //允许质证的用户类型
  private String totalOpinion;   //总意见
  private String tdhFileId;  //通达海附件id

  private String imgFileId; //对于文书生成的img file id

  private String type;
  private String createTime; //创建时间
}
