package com.beiming.odr.referee.enums;

/**
 * @author zhouxin
 * @since 2019/8/6
 */
public enum ExamineStatusEnum {
  UNREVIEWED(0, "未审核"),
  REVIEW_PASS(1, "审核通过"),
  REVIEW_NO_PASS(2, "审核不通过"),
  ;
  private final Integer index;
  private final String desc;


  ExamineStatusEnum(int index, String desc) {
    this.index = index;
    this.desc = desc;
  }

  public static Boolean isExamine(Integer examineResult) {
    return REVIEW_PASS.getIndex() == examineResult || REVIEW_NO_PASS.getIndex() == examineResult;
  }

  public int getIndex() {
    return index;
  }

  public String getDesc() {
    return desc;
  }

  public static ExamineStatusEnum findByIndex(Integer index) {
    if (index == null) {
      return UNREVIEWED;
    }
    for (ExamineStatusEnum en : values()) {
      if (index.equals(en.getIndex())) {
        return en;
      }
    }
    return UNREVIEWED;
  }
}
