package com.beiming.odr.referee.enums;

/**
 * Created by Jache on 2019/09/04 16:35.
 */
public enum GuangQingResultEnum {
  SUCCESS(0, "成功"),
  LOADING(1, "查询中"),
  SERVER_ERROR(500, "服务异常，请联系管理员"),

  APPID_NULL(101, "appid为空"),
  TIMESTAMP_NULL(102, "timestamp为空"),
  NONCE_NULL(103, "nonce为空"),
  SIGN_NULL(104, "sign为空"),
  APIID_NULL(105, "apiid为空"),

  TIMESTAMP_ERROR(106, "timestamp错误"),
  NO_PERMISSION(107, "没有权限"),
  SIGN_ERROR(108, "签名错误"),
  NONCE_ERROR(109, "nonce错误"),
  REQUEST_EMPTY(110, "请求内容为空"),
  REQUEST_FORMAT_ERROR(110, "请求内容格式错误"),

  ;
  private Integer code;

  private String desc;

  public Integer code() {
    return code;
  }

  public String desc() {
    return desc;
  }

  GuangQingResultEnum(Integer code, String desc) {
    this.code = code;
    this.desc = desc;
  }

  public GuangQingResultEnum getEnum(Integer code) {
    GuangQingResultEnum result = null;
    for (GuangQingResultEnum g : GuangQingResultEnum.values()) {
      if (g.code.equals(code)) result = g;
    }
    return result;
  }
}
