package com.beiming.odr.referee.enums;

import com.beiming.framework.domain.DubboResultCode;
import com.beiming.framework.domain.ResultCode;

/**
 * @author chenpeng
 * @Title: SendTDHErrorEnum
 * @ProjectName 通达海code 信息
 * @Description: TODO
 * @date 2019/1/1912:13
 */
public enum SendTDHErrorEnum implements DubboResultCode, ResultCode {
  SUCCESS(0, "正常返回"),
  SERVER_REQUEST_ERROR(101, "服务器请求失败"),
  PARAMETER_ERROR(102, "参数错误"),
  AES_ERROR(103, "AES解密失败"),
  NO_ACCESS_TOKEN(104, "accessToken缺失或者已失效"),
  SERVER_ERROR(105, "内部参数错误"),
  SIGN_ERROR(106, "验签失败"),
  NO_APP_ID(107, "缺少appId"),
  NO_SIGN(108, "缺少signature参数"),
  NO_TIMESTAMP(109, "缺少timestamp时间戳"),






  ;

  private int value;
  private String desc;

  SendTDHErrorEnum(int code, String name) {
    this.value = code;
    this.desc = name;
  }

  public int getValue() {
    return value;
  }

  public void setValue(int value) {
    this.value = value;
  }

  public String getDesc() {
    return desc;
  }

  public void setDesc(String desc) {
    this.desc = desc;
  }

  /**
   * 根据code获取去value
   */
  public static String getNameByCode(int code) {
    for (SendTDHErrorEnum error : SendTDHErrorEnum.values()) {
      if (code == error.getValue()) {
        return error.getDesc();
      }
    }
    return null;
  }

  @Override
  public int value() {
    return this.getValue();
  }

  @Override
  public String desc() {
    return this.getDesc();
  }

  public static SendTDHErrorEnum getSendTDHErrorEnum(int code) {
    for (SendTDHErrorEnum error : SendTDHErrorEnum.values()) {
      if (code == error.getValue()) {
        return error;
      }
    }
    return null;
  }
}
