package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.referee.dto.requestdto.CaseImportListIdsReqDTO;
import com.beiming.odr.referee.dto.requestdto.LawCaseImportExistReqDTO;
import com.beiming.odr.referee.dto.requestdto.LawCaseImportReqDTO;
import com.beiming.odr.referee.dto.requestdto.LawCaseImportSaveReqDTO;
import com.beiming.odr.referee.dto.requestdto.MediationImportCaseReqDTO;
import com.beiming.odr.referee.dto.responsedto.LawCaseImportExistResDTO;
import com.beiming.odr.referee.dto.responsedto.LawCaseImportListResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationImportCaseResDTO;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;


/**
 * 案件导入api
 * 
 * @author qsh
 *
 * @2019年3月1日
 */
@Valid
public interface LawCaseImportApi {

  /**
   * 案件导入列表
   * 
   * @param lawCaseImportReqDTO
   * @return
   */
  DubboResult<PageInfo<LawCaseImportListResDTO>> queryCaseImportList(
      LawCaseImportReqDTO lawCaseImportReqDTO);

  /**
   * 是否需要发送短信
   * 
   * @param caseImportListIdsReqDTO
   * @return
   */
  DubboResult<Boolean> sendSmsCaseImport(@Valid CaseImportListIdsReqDTO caseImportListIdsReqDTO);

  /**
   * 保存导入案件相关信息
   * @return
   */
  DubboResult saveImportCaseData(LawCaseImportSaveReqDTO reqDTO);

  /**
   * 批量保存导入案件相关信息
   * @return
   */
  DubboResult saveImportCaseDataList(List<LawCaseImportSaveReqDTO> reqDTOList);

  /**
   * 根据文件名查询已导入案件
   * @return
   */
  DubboResult<ArrayList<LawCaseImportExistResDTO>> queryExistImportData(
      LawCaseImportExistReqDTO reqDTO);

  /**
   * 批量导入案件
   */
  DubboResult<ArrayList<MediationImportCaseResDTO>> insertMediationImportCaseList(
      List<MediationImportCaseReqDTO> reqDTOList);

}
