package com.beiming.odr.referee.dto.requestdto;

import com.beiming.framework.page.PageQuery;
import com.beiming.odr.referee.dto.MediationListDTO;
import com.beiming.odr.referee.enums.CaseProgressEnum;
import java.io.Serializable;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 查询调解列表的请求参数
 *
 * @author DJQ 2018年7月9日
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class MediationListReqDTO  extends PageQuery implements Serializable {

  private static final long serialVersionUID = -2326143176608490189L;

  private String roleType; // 用户角色类型： 纠纷登记员 调解人 普通人/**
  private String pageSource; // 页面来源:ORG_MANAGE(案件分配列表),ORG_RECORD(案件调解记录)
  private Long userId; // 用户ID
  private String userType; // 用户类型（申请人，被申请人，调解人）
  private Long orgId; // 服务机构编号
  private String disputeTypeCode; // 纠纷类型
  private String disputeNo; // 纠纷编号
  private Integer approvalType; // 审批类型：1=延期；2=纠纷信息；3=延期及纠纷
  private List<CaseProgressEnum> caseProgress; // 案件进度
  // private String areaCode; // 地区编号
  private String provCode; // 省份code
  private String cityCode; // 城市code
  private String areaCode; // 区code
  private String streetCode; // 街道code
  private List<String> keyWord; // 关键词 编号、姓名、案号
  private String startTime;
  private String endTime;
  private Long queryOrgId; //根据机构id筛选
  private List<Long> queryOrgIds; //根据机构id筛选
  private String mediationType; // 调解类型
  private String partyName; //当事人姓名
  private Integer actionType; //全部0，批量分配1，批量转移2
  private String origin;
  private String followName;
  private String followMobile;
  private Integer draft;
  private Integer visit;
  private List<String> areaCodePrefixList; //地区编码前缀，查某地区及所有下级地区
  private List<Long> orgIds; //根据多个机构id筛选

  // 0-全部 1-关键字 2-地域发生地 3-地域常住地 4-调解 5-仲裁 6-诉讼 7-归属单位 8-未匹配
  private Integer analysisMatches = 0;

  /**
   * 当前orgId
   */
  private Long currentOrgId;

  /**
   * 数据状态
   */
  private Integer status;

  /**
   * 根据案件状态来区分 网上立案和司法确认数据列表
   */
  private String lawStatus;

  /**
   * 是否简易案件 1是0否
   */
  private Integer simple;


  /**
   * 调解员名称
   */
  private String mediatorName;

  private String manageCode;

  private Integer areaLevel;

  private String resolutionType;

  /**
   * 转换为Mapper查询对象
   *
   * @return
   */
  public MediationListDTO convertMediationListDTO(List<String> caseStatus) {
    MediationListDTO listDTO = new MediationListDTO();

    listDTO.setRoleType(roleType); // 用户角色类型： 纠纷登记员 调解人 普通人
    listDTO.setUserId(userId); // 用户ID
    listDTO.setUserType(userType); // 用户类型（申请人，被申请人，调解人）
    listDTO.setOrgId(orgId); // 服务机构编号

    listDTO.setDisputeTypeCode(disputeTypeCode); // 纠纷类型
    listDTO.setDisputeNo(disputeNo); // 纠纷编号
    listDTO.setApprovalType(approvalType); // 审批类型：1=延期；2=纠纷信息；3=延期及纠纷
    listDTO.setCaseStatus(caseStatus); // 案件进度
    // listDTO.setareaCode; // 地区编号
    listDTO.setProvCode(provCode); // 省份code
    listDTO.setCityCode(cityCode); // 城市code
    listDTO.setAreaCode(areaCode); // 区code
    listDTO.setStreetCode(streetCode); // 街道code
    listDTO.setKeyWord(keyWord); // 关键词 编号、姓名、案号
    listDTO.setStartTime(startTime);
    listDTO.setEndTime(endTime);
    listDTO.setMediationType(mediationType);
    listDTO.setPartyName(partyName);
    listDTO.setQueryOrgId(queryOrgId);
    listDTO.setPageIndex(this.getPageIndex());
    listDTO.setPageSize(this.getPageSize());
    listDTO.setActionType(this.getActionType());
    listDTO.setOrigin(origin);
    listDTO.setDraft(draft);
    listDTO.setVisit(visit);
    listDTO.setOrgIds(orgIds);
    listDTO.setAreaCodePrefixList(areaCodePrefixList);
    return listDTO;
  }

}
