package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import com.beiming.odr.referee.enums.CaseProgressEnum;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 案件数量统计结果请求
 * 
 * @author DJQ 2018年7月9日
 *
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MediationStatusCountReqDTO implements Serializable {

  private static final long serialVersionUID = -2151133273317063743L;

  private Long id; //
  private String type; // 类别：机构ORG_MANAGE/AREA_MANAGE、调解员MEDIATOR、普通用户COMMON
  private String caseProgressCode; //
  private List<CaseProgressEnum> caseProgress; // 案件进度
  private List<String> areaCodePrefixList; //地区编码前缀，查某地区及所有下级地区
  private List<Long> orgIds; //根据多个机构id筛选
}
