package com.beiming.odr.referee.enums;

/**
 * @Description: 案件来源枚举
 * @Author: caiwei
 * @Date: Created 2018-06-26
 */
public enum CaseOriginEnum {

//  ODR_PLATFORM("本平台录入"),  ONLINE_PLATFORM(
//      "网上立案系统"), LAW_PLATFORM("律师平台");
//  THIRD_PLATFORM("第三方平台"),
//  PERSONAL("个人立案"), COURT("法院引调"),
  DIRECTIONAL("定向收案"),


  PERSONAL("当事人申请案件"),
  MEDIATOR("调解员录入案件"),
  LOCAL_GOVERNMENT("地方政府委托案件"),
  COURT("法院委托案件"),
  POLICE_STATION("驻所系统导入案件"),
  LETTERS_VISITS("信访部门委托案件"),
  OTHER("其它部门委托案件");

  private String name;

  CaseOriginEnum(String name) {
    this.name = name;
  }
  public String getName() {
    return name;
  }

  //通过英文code返回类型的中文名
  public static String getCodeName(String code) {
    String codeName = "未知";
    try {
      codeName = CaseOriginEnum.valueOf(code).getName();
    } catch (Exception e) {
    }
    return codeName;
  }
}
