package com.beiming.odr.referee.enums;

/**
 * 联系状态枚举
 *
 * @author zhouxin
 * @see com.beiming.odr.referee.domain.entity.LawCaseFinancial#contactStatus
 * @since 2019/8/5
 */
public enum ContactStatusEnum {

  // 未联系
  NOT_CONTACTED(0, "--"),
  CONTACTED(1, "联系"),
  REJECT(2, "拒接"),
  LOSS_ASSOCIATI1ON(3, "失联"),
  ;

  private final int index;
  private final String desc;

  ContactStatusEnum(int index, String desc) {
    this.index = index;
    this.desc = desc;
  }

  public int getIndex() {
    return index;
  }

  public String getDesc() {
    return desc;
  }

  public static ContactStatusEnum findByIndex(Integer index) {
    if (index == null) {
      return NOT_CONTACTED;
    }
    for (ContactStatusEnum en : values()) {
      if (index.equals(en.getIndex())) {
        return en;
      }
    }
    return NOT_CONTACTED;
  }
}
